% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwu.R
\name{mwu}
\alias{mwu}
\title{Mann-Whitney-U-Test}
\usage{
mwu(data, x, grp, distribution = "asymptotic", out = c("txt", "viewer",
  "browser"))
}
\arguments{
\item{data}{A data frame.}

\item{x}{Bare (unquoted) variable name, or a character vector with the variable name.}

\item{grp}{Bare (unquoted) name of the cross-classifying variable, where
\code{x} is grouped into the categories represented by \code{grp},
or a character vector with the variable name.}

\item{distribution}{Indicates how the null distribution of the test statistic should be computed.
May be one of \code{"exact"}, \code{"approximate"} or \code{"asymptotic"}
(default). See \code{\link[coin]{wilcox_test}} for details.}

\item{out}{Character vector, indicating whether the results should be printed
to console (\code{out = "txt"}) or as HTML-table in the viewer-pane
(\code{out = "viewer"}) or browser (\code{out = "browser"}), of if the
results should be plotted (\code{out = "plot"}, only applies to certain
functions). May be abbreviated.}
}
\value{
(Invisibly) returns a data frame with U, p and Z-values for each group-comparison
        as well as effect-size r; additionally, group-labels and groups' n's are
        also included.
}
\description{
This function performs a Mann-Whitney-U-Test (or Wilcoxon rank sum test,
               see \code{\link[stats]{wilcox.test}} and \code{\link[coin]{wilcox_test}})
               for \code{x}, for each group indicated by \code{grp}. If \code{grp}
               has more than two categories, a comparison between each combination of
               two groups is performed. \cr \cr
               The function reports U, p and Z-values as well as effect size r
               and group-rank-means.
}
\note{
This function calls the \code{\link[coin]{wilcox_test}} with formula. If \code{grp}
        has more than two groups, additionally a Kruskal-Wallis-Test (see \code{\link{kruskal.test}})
        is performed. \cr \cr
        Interpretation of effect sizes, as a rule-of-thumb:
        \itemize{
         \item small effect >= 0.1
         \item medium effect >= 0.3
         \item large effect >= 0.5
       }
}
\examples{
data(efc)
# Mann-Whitney-U-Tests for elder's age by elder's dependency.
mwu(efc, e17age, e42dep)

}
