% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust.R
\name{robust}
\alias{robust}
\alias{svy}
\title{Robust standard errors for regression models}
\usage{
robust(x, vcov.fun = "vcovHC", vcov.type = c("HC3", "const", "HC",
  "HC0", "HC1", "HC2", "HC4", "HC4m", "HC5"), vcov.args = NULL,
  conf.int = FALSE, exponentiate = FALSE)

svy(x, vcov.fun = "vcovHC", vcov.type = c("HC1", "const", "HC", "HC0",
  "HC3", "HC2", "HC4", "HC4m", "HC5"), vcov.args = NULL,
  conf.int = FALSE, exponentiate = FALSE)
}
\arguments{
\item{x}{A fitted model of any class that is supported by the \code{vcov*()}-functions
from the \pkg{sandwich} package. For \code{svy()}, \code{x} must be
\code{lm} object, fitted with weights.}

\item{vcov.fun}{String, indicating the name of the \code{vcov*()}-function
from the \pkg{sandwich}-package, e.g. \code{vcov.fun = "vcovCL"}.}

\item{vcov.type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich]{vcovHC}}
for details).}

\item{vcov.args}{List of named vectors, used as additional arguments that
are passed down to \code{vcov.fun}.}

\item{conf.int}{Logical, \code{TRUE} if confidence intervals based on robust
standard errors should be included.}

\item{exponentiate}{Logical, whether to exponentiate the coefficient estimates
and confidence intervals (typical for logistic regression).}
}
\value{
A summary of the model, including estimates, robust standard error,
          p-value and - optionally - the confidence intervals.
}
\description{
\code{robust()} computes robust standard error for regression models.
   This method calls one of the \code{vcov*()}-functions from the
   \pkg{sandwich}-package for robust covariance matrix estimators. Results are
   returned as tidy data frame.
   \cr \cr
   \code{svy()} is intended to compute standard errors for survey
   designs (complex samples) fitted with regular \code{lm} or
   \code{glm} functions, as alternative to the \pkg{survey}-package.
   It simulates sampling weights by adjusting the residual degrees
   of freedom based on the precision weights used to fit \code{x},
   and then calls \code{robust()} with the adjusted model.
}
\note{
\code{svy()} simply calls \code{robust()}, but first adjusts the
      residual degrees of freedom based on the model weights.
      Hence, for \code{svy()}, \code{x} should be fitted with weights.
      This simulates \emph{sampling weights} like in survey designs, though
      \code{lm} and \code{glm} implement \emph{precision weights}.
      The results from \code{svy()} are usually more accurate than simple
      weighted standard errors for complex samples. However, results from
      the \pkg{survey} package are still more exactly, especially
      regarding the estimates.
      \cr \cr
      \code{vcov.type} for \code{svy()} defaults to \code{"HC1"}, because
      standard errors with this estimation type come closest to the standard
      errors from the \pkg{survey}-package.
      \cr \cr
      Currently, \code{svy()} only works for objects of class \code{lm}.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
summary(fit)
robust(fit)

confint(fit)
robust(fit, conf.int = TRUE)
robust(fit, vcov.type = "HC1", conf.int = TRUE) # "HC1" should be Stata default

library(sjmisc)
# dichtomozize service usage by "service usage yes/no"
efc$services <- sjmisc::dicho(efc$tot_sc_e, dich.by = 0)
fit <- glm(services ~ neg_c_7 + c161sex + e42dep,
           data = efc, family = binomial(link = "logit"))

robust(fit)
robust(fit, conf.int = TRUE, exponentiate = TRUE)

}
