skip_if_not_installed("coin")
skip_if_not_installed("survey")
skip_if_not_installed("datawizard")

test_that("mann_whitney_test", {
  data(efc)
  set.seed(123)
  efc$weight <- abs(rnorm(nrow(efc), 1, 0.3))
  out1 <- mann_whitney_test(efc, "e17age", by = "e16sex")
  out2 <- wilcox.test(e17age ~ e16sex, data = efc)
  expect_equal(out1$w, out2$statistic, tolerance = 1e-4, ignore_attr = TRUE)
  expect_equal(out1$p, out2$p.value, tolerance = 1e-4, ignore_attr = TRUE)
  expect_equal(out1$estimate, -151, tolerance = 1e-4, ignore_attr = TRUE)
  expect_equal(out1$r, 0.2571254, tolerance = 1e-4, ignore_attr = TRUE)
  expect_snapshot(print(out1))

  set.seed(123)
  wide_data <- data.frame(scale1 = runif(20), scale2 = runif(20))
  out1 <- mann_whitney_test(wide_data, select = c("scale1", "scale2"))
  out2 <- wilcox.test(wide_data$scale1, wide_data$scale2)
  expect_equal(out1$w, out2$statistic, tolerance = 1e-4, ignore_attr = TRUE)
  expect_equal(out1$p, out2$p.value, tolerance = 1e-4, ignore_attr = TRUE)
  expect_equal(out1$r, 0.05132394, tolerance = 1e-4, ignore_attr = TRUE)
  expect_snapshot(print(out1))

  out <- mann_whitney_test(efc, "e17age", by = "e16sex", weights = "weight")
  expect_equal(out$p, 1.976729e-14, tolerance = 1e-4, ignore_attr = TRUE)
  expect_equal(out$estimate, 0.1594972, tolerance = 1e-4, ignore_attr = TRUE)
  expect_equal(out$r, 0.2599877, tolerance = 1e-4, ignore_attr = TRUE)
  expect_snapshot(print(out))
})

test_that("mann_whitney_test, sanity checks", {
  data(efc)
  expect_error(mann_whitney_test(efc, "e17age", by = "c172code"), regex = "Only two groups are")
  expect_error(mann_whitney_test(efc, c("e17age", "c172code", "e16sex")), regex = "You may only specify")
  expect_error(mann_whitney_test(efc, c("e17age", "c172code"), by = "e17age"), regex = "If `select` specifies more")
  expect_error(mann_whitney_test(efc, "e17age"), regex = "Only one variable provided")
})
