% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glejser.R
\name{glejser}
\alias{glejser}
\title{Glejser Test for Heteroskedasticity in a Linear Regression Model}
\usage{
glejser(mainlm, auxdesign = NULL)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} "lm", or a list
of two components: a response vector and a design matrix (in that order).
If the latter, the design matrix must begin with a column of 1s if an
intercept is to be included in the linear model. Passing an object of
class "lm" is recommended in applications; passing a list containing
the data is recommended where optimising computational performance is
important.}

\item{auxdesign}{A \code{\link[base]{data.frame}} or
\code{\link[base]{matrix}} representing an auxiliary design matrix of
containing exogenous variables that (under alternative hypothesis) are
related to error variance, or a character "fitted.values" indicating
that the fitted \eqn{\hat{y}_i} values from OLS should be used.
If set to \code{NULL} (the default), the
design matrix of the original regression model is used. An intercept
is included in the auxiliary regression even if the first column of
\code{auxdesign} is not a vector of ones.}
}
\value{
An object of \code{\link[base]{class}} "htest". If object is not
   assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the method of
   \insertCite{Glejser69;textual}{skedastic} for testing for "multiplicative"
   heteroskedasticity in a linear regression model.
   \insertCite{Mittelhammer00;textual}{skedastic} gives the
   formulation of the test used here.
}
\details{
Glejser's Test entails fitting an auxiliary regression model in
   which the response variable is the absolute residual from the original
   model and the design matrix \eqn{Z} consists of one or more exogenous
   variables that are suspected of being related to the error variance.
   In the absence of prior information on a possible choice of \eqn{Z},
   one would typically use the explanatory variables from the original model.
   Under the null hypothesis of homoskedasticity, the distribution of the
   test statistic is asymptotically chi-squared with \code{parameter} degrees
   of freedom. The test is right-tailed.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
glejser(mtcars_lm)

}
\references{
{\insertAllCited{}}
}
\seealso{
the description of the test in
  \href{http://www.econometrics.com/intro/testhet.htm}{SHAZAM} software
  (which produces identical results).
}
