% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/honda.R
\name{honda}
\alias{honda}
\title{Honda's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
honda(
  mainlm,
  deflator = NA,
  alternative = c("two.sided", "greater", "less"),
  twosidedmethod = c("doubled", "kulinskaya"),
  qfmethod = "imhof",
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NA} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{alternative}{A character specifying the form of alternative
hypothesis. If it is suspected that the error variance is positively
associated with the deflator variable, \code{"greater"}. If it is
suspected that the error variance is negatively associated with deflator
variable, \code{"less"}. If no information is available on the suspected
direction of the association, \code{"two.sided"}. Defaults to
\code{"greater"}.}

\item{twosidedmethod}{A character indicating the method to be used to compute
two-sided \eqn{p}-values for the parametric test when \code{alternative}
is \code{"two.sided"}. The argument is passed to
\code{\link{twosidedpval}} as its \code{method} argument.}

\item{qfmethod}{A character, either \code{"imhof"}, \code{"davies"}, or
\code{"integrate"}, corresponding to the \code{algorithm} argument
of \code{\link[skedastic]{pRQF}}. The default is \code{"imhof"}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the two-sided LM Test of
   \insertCite{Honda89;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The test assumes that heteroskedasticity, if present, would be either of
   the form \eqn{\sigma_i^2 = \sigma^2(1+\theta z_i)} or of the
   form \eqn{\sigma_i^2 = \sigma^2 e^{\theta z_i}}, where
   where \eqn{z_i} is a deflator (a nonstochastic variable
   suspected of being related to the error variance), \eqn{\sigma^2} is
   some unknown constant, and \eqn{\theta} is an unknown parameter
   representing the degree of heteroskedasticity. Since the test
   statistic \eqn{Q=\frac{e' A_0 e}{e'e}} is a ratio of quadratic forms
   in the errors, the Imhof algorithm is used to compute \eqn{p}-values.
   Since the null distribution is in general asymmetrical, the two-sided
   \eqn{p}-value is computed using the conditional method of
   \insertCite{Kulinskaya08;textual}{skedastic}, setting \eqn{A=1}.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
honda(mtcars_lm, deflator = "qsec")

}
\references{
{\insertAllCited{}}
}
