% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hccme.R
\name{hccme}
\alias{hccme}
\title{Heteroskedasticity-Consistent Covariance Matrix Estimators for
   Linear Regression Models}
\usage{
hccme(
  mainlm,
  hcnum = c("3", "0", "1", "2", "4", "5", "6", "7", "4m", "5m", "const"),
  sandwich = FALSE,
  as_matrix = TRUE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{hcnum}{A character corresponding to a subscript in the name of an
HCCME according to the usual nomenclature \eqn{\mathrm{HC\#}}.
Possible values are:
\itemize{
 \item "3", the default, corresponding to HC3
\insertCite{MacKinnon85}{skedastic}
 \item "0", corresponding to HC0 \insertCite{White80}{skedastic}
 \item "1", corresponding to HC1 \insertCite{MacKinnon85}{skedastic}
 \item "2", corresponding to HC1 \insertCite{MacKinnon85}{skedastic}
 \item "4", corresponding to HC4 \insertCite{Cribari04}{skedastic}
 \item "5", corresponding to HC5 \insertCite{Cribari07}{skedastic}
 \item "6", corresponding to HC6 \insertCite{Aftab16}{skedastic}
 \item "7", corresponding to HC7 \insertCite{Aftab18}{skedastic}
 \item "4m", corresponding to HC4m \insertCite{Cribari11}{skedastic}
 \item "5m", corresponding to HC5m \insertCite{Li17}{skedastic}
 \item "const", corresponding to the homoskedastic estimator,
 \eqn{(n-p)^{-1}\displaystyle\sum_{i=1}^{n}e_i^2}
}}

\item{sandwich}{A logical, defaulting to \code{FALSE}, indicating
whether or not the sandwich estimator
\deqn{\mathrm{Cov}{\hat{\beta}}=(X'X)^{-1}X'\hat{\Omega}X(X'X)^{-1}}
should be returned instead of \eqn{\mathrm{Cov}(\epsilon)=\hat{\Omega}}}

\item{as_matrix}{A logical, defaulting to \code{TRUE}, indicating whether
a covariance matrix estimate should be returned rather
than a vector of variance estimates}
}
\value{
A numeric matrix (if \code{as_matrix} is \code{TRUE}) or else a
   numeric vector
}
\description{
Computes an estimate of the \eqn{n\times n} covariance matrix \eqn{\Omega}
   (assumed to be diagonal) of the random error vector of a linear
   regression model, using a specified method
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
Omega_hat <- hccme(mtcars_lm, hcnum = "4")
Cov_beta_hat <- hccme(mtcars_lm, hcnum = "4", sandwich = TRUE)

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link[sandwich]{vcovHC}}
}
