% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra-websocket.R
\name{websocket}
\alias{websocket}
\title{Websocket for 'sketch' applications}
\description{
This combines the *-Server family of functions in 'httpuv'
with the transpilation functionality provided by 'sketch'.
}
\examples{

## ------------------------------------------------
## Method `websocket$new`
## ------------------------------------------------

\dontrun{
# Launch a WebSocket server
ws <- websocket$new()
ws$startServer()
ws$listServers()    # Check that a server is running

# Launch a 'sketch' application with WebSocket functionality
file <- system.file("test_files/test_websocket.R", package = "sketch")
source_r(file, debug = TRUE)   # Launch the default browser

# Enter sketch mode to send commands to the application
ws$sketch_mode()
# Within sketch mode
print("1234")
x <- 10
print(x + 1)
q()

# Back to normal mode, inspect the log and stop the server
ws$log
ws$stopServer()
ws$listServers()    # Confirm no server is running
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{app}}{A list of functions that define the application.}

\item{\code{server}}{A server handle to be used by 'stopServer'.}

\item{\code{log}}{A character vector that keep tracks of all the commands
sent to the browser session.}

\item{\code{ws}}{A WebSocket channel to handle the communication between
the R session and the browser session.}

\item{\code{in_handler}}{A function to handle instructions sent by the
browser session.}

\item{\code{out_handler}}{A function to handle instruction sent to the
browser session.}

\item{\code{env}}{An environment to store variables temporarily.}

\item{\code{port}}{An integer; the TCP port number.}

\item{\code{message}}{TRUE or FALSE; whether to display a prompt when
a server is started and when it is stopped.}

\item{\code{connected}}{TRUE or FALSE; whether a connection has been established.
One should ways start the WebSocket server before visiting the web page
that connects to the server.}

\item{\code{started}}{TRUE or FALSE; whether a server has been started. Use
the \code{startServer} method to start a server.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-startServer}{\code{websocket$startServer()}}
\item \href{#method-stopServer}{\code{websocket$stopServer()}}
\item \href{#method-listServers}{\code{websocket$listServers()}}
\item \href{#method-stopAllServers}{\code{websocket$stopAllServers()}}
\item \href{#method-sketch_mode}{\code{websocket$sketch_mode()}}
\item \href{#method-new_app}{\code{websocket$new_app()}}
\item \href{#method-new}{\code{websocket$new()}}
\item \href{#method-clone}{\code{websocket$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-startServer"></a>}}
\if{latex}{\out{\hypertarget{method-startServer}{}}}
\subsection{Method \code{startServer()}}{
Start a WebSocket server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$startServer()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stopServer"></a>}}
\if{latex}{\out{\hypertarget{method-stopServer}{}}}
\subsection{Method \code{stopServer()}}{
Stop a WebSocket server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$stopServer()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-listServers"></a>}}
\if{latex}{\out{\hypertarget{method-listServers}{}}}
\subsection{Method \code{listServers()}}{
List all running WebSocket servers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$listServers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stopAllServers"></a>}}
\if{latex}{\out{\hypertarget{method-stopAllServers}{}}}
\subsection{Method \code{stopAllServers()}}{
Stop all running WebSocket servers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$stopAllServers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sketch_mode"></a>}}
\if{latex}{\out{\hypertarget{method-sketch_mode}{}}}
\subsection{Method \code{sketch_mode()}}{
Enter sketch mode, in which all commands go through
the transpiler before reaching the browser session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$sketch_mode()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new_app"></a>}}
\if{latex}{\out{\hypertarget{method-new_app}{}}}
\subsection{Method \code{new_app()}}{
Create a blank HTML page with interactive access.
This function is designed for newcomers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$new_app(
  preamble = list(library = c(), script = c(), data = c()),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{preamble}}{(Optional) A named list; the preamble to include.
Use the name 'lib' for arguments to \code{load_library}, 'script'
for arguments to \code{load_script} and 'data' for arguments to
\code{load_data}. Note that the "dom" and "websocket" modules are
required and loaded by default.}

\item{\code{...}}{Extra parameters to pass to \link{source_r}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The (invisible) temporary file path to the app.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialise a WebSocket connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$new(in_handler, out_handler, message = TRUE, port = 9454)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{in_handler}}{A function to handle incoming message, default to
be \link[base:print]{print} which only displays the message without
any processing.}

\item{\code{out_handler}}{A function to handle outgoing message, default to
be \link{compile_exprs} which transpiles R commands into JavaScript
commands.}

\item{\code{message}}{TRUE or FALSE; whether to display a prompt when
a server is started and when it is stopped.}

\item{\code{port}}{An integer; the TCP port number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A 'websocket' object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# Launch a WebSocket server
ws <- websocket$new()
ws$startServer()
ws$listServers()    # Check that a server is running

# Launch a 'sketch' application with WebSocket functionality
file <- system.file("test_files/test_websocket.R", package = "sketch")
source_r(file, debug = TRUE)   # Launch the default browser

# Enter sketch mode to send commands to the application
ws$sketch_mode()
# Within sketch mode
print("1234")
x <- 10
print(x + 1)
q()

# Back to normal mode, inspect the log and stop the server
ws$log
ws$stopServer()
ws$listServers()    # Confirm no server is running
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
