% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{stSim}
\alias{stSim}
\title{Simulate user tracked menstrual cycle data for an individual, based on the skipTrack model.}
\usage{
stSim(i, skipProb, maxCycles, trueBetas, trueGammas, overlap, avgCyclesPer)
}
\arguments{
\item{i}{Individual identifier. Character, numeric or integer.}

\item{skipProb}{Vector of probabilities for number of true cycles per tracked cycle. For
example, (.7, .2, .1) means that 70\% of observed cycles will contain one true cycle, 20\%
will contain 2 true cycles and 10\% will contain 3 true cycles.}

\item{maxCycles}{Maximum number of true cycles per tracked cycle. Ignored for this model.}

\item{trueBetas}{Optional. True values for the mean regression coefficients (not counting intercept which is automatic based on the model).}

\item{trueGammas}{Optional. True values for the precision regression coefficients (not counting intercept which is automatic based on the model).}

\item{overlap}{Optional. Number of (non-intercept) columns shared between X and Z. Columns are shared from left to right.}

\item{avgCyclesPer}{Average number of cycles contributed by each individual. Actual number is drawn from Poisson for each person. Default is 7.}
}
\value{
\describe{
\item{'Individual'}{Individual identifiers.}
\item{'TrackedCycles'}{Tracked cycles.}
\item{'NumTrue'}{Number of true values.}
\item{'LogMean'}{Individual's mean of log(Y).}
\item{'LogPrec'}{Individual's precision of log(Y)}
\item{'Beta0'}{Beta0 true value.}
\item{'Gamma0'}{Gamma0 true value.}
\item{'X0',...,'XN'}{Covariate matrix for Mean, where N is the length of trueBetas.}
\item{'Z0',...,'ZM'}{Covariate matrix for precision, where M is the length of trueGammas.}
}
}
\description{
This function generates synthetic data for user tracked menstrual cycles for a
single individual. For this model Beta_0 = log(30), Gamma_0 = 5.5, and phi = .01.
}
\seealso{
\code{\link{skipTrack.simulate}}
}
