% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_forecast.R
\name{modeltime_wfs_forecast}
\alias{modeltime_wfs_forecast}
\title{Modeltime workflow sets forecast}
\usage{
modeltime_wfs_forecast(.wfs_results, .series, .split_prop = NULL, .h = NULL)
}
\arguments{
\item{.wfs_results}{tibble of combination of recipes and models fitted, generated with the \code{modeltime_wfs_fit()} function.}

\item{.series}{time series dataframe.}

\item{.split_prop}{time series split proportion.}

\item{.h}{time series horizon from the \code{modeltime_forecast()} function from 'modeltime' package.}
}
\value{
a tibble containing the forecast for each model.
}
\description{
forecast from a set of recipes and models trained by \code{modeltime_wfs_fit()} function.
}
\details{
since it uses the \code{modeltime_forecast()} function from 'modeltime' package, either the forecast
can be made on new data or on a number of periods.
}
\examples{
library(dplyr)
library(modeltime)
library(earth)

data <- sknifedatar::data_avellaneda \%>\%  mutate(date=as.Date(date)) \%>\% 
filter(date<'2012-06-01')

recipe_date <- recipes::recipe(value ~ ., data = data) \%>\% 
  recipes::step_date(date, features = c('dow','doy','week','month','year')) 

mars <- parsnip::mars(mode = 'regression') \%>\%
  parsnip::set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    R_date = recipe_date),
  models  = list(M_mars = mars),
  cross   = TRUE)

wffits <- sknifedatar::modeltime_wfs_fit(.wfsets = wfsets, 
                                         .split_prop = 0.8, 
                                         .serie=data)
                            
sknifedatar::modeltime_wfs_forecast(.wfs_results=wffits, 
                                    .series = data,
                                    .split_prop = 0.8) 
                                     
}
