% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_save}
\alias{ts_save}
\title{Save a tree sequence to a file}
\usage{
ts_save(ts, file)
}
\arguments{
\item{ts}{Tree sequence object loaded by \code{ts_load}}

\item{file}{File to which the tree sequence should be saved}
}
\value{
No return value, called for side effects
}
\description{
Save a tree sequence to a file
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree sequence
ts <- ts_load(slendr_ts, model)

# save the tree-sequence object to a different location
another_file <- paste(tempfile(), ".trees")
ts_save(ts, another_file)
}
