% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slickR.R
\name{slickR}
\alias{slickR}
\title{slick.js image carousel htmlwidget}
\usage{
slickR(
  obj,
  slideId = "baseDiv",
  slideType = "img",
  objLinks = NULL,
  padding = 1,
  width = "95\%",
  height = NULL,
  elementId = NULL,
  slickOpts = NULL,
  synchSlides = NULL,
  dotObj = NULL
)
}
\arguments{
\item{obj}{character, vector of path or url to images}

\item{slideId}{character, id of slide, Default: 'baseDiv'}

\item{slideType}{character, type of object to put in slide, Default: 'img'}

\item{objLinks}{character, links to attach to images in slide, Default: NULL}

\item{padding}{numeric, percent of width between each image in the carousel
for each slider, Default: 1}

\item{width}{character, width of htmlwidget, Default: '95\%'}

\item{height}{character, height of htmlwidget, Default: NULL}

\item{elementId}{character, id tag of htmlwidget, Default: NULL}

\item{slickOpts}{\lifecycle{deprecated}}

\item{synchSlides}{\lifecycle{deprecated}}

\item{dotObj}{\lifecycle{deprecated}}
}
\description{
use slick.js library in R
}
\details{
\href{http://kenwheeler.github.io/slick/}{slick.js} is an image carousel javascript library.

To find all the attributes that can be used please refer to the link.

It is possible to stack slides through the \verb{\%stack\%} operator.

It is possible to synchronize slides through the \verb{\%synch\%} operator.

To replace the dots with icons use the settings to define the  customPaging
attribute with the appropriate JS(.) function call.

The slideType accepts the type of html DOM you want to be in the slide, eg img, iframe.

The combination of slideType = 'img-lazy' and settings(lazyLoad = 'ondemand') will
inform the htmlwidget that the images are to be loaded lazily.
For more information see the slickjs \href{http://kenwheeler.github.io/slick/}{documentation}.
}
\examples{


if(interactive()){

slick <- slickR(obj=nba_team_logo$uri)

slick

# add dots to the first slick and autoplay at 1 second a slide
 
slick + settings(dots = TRUE, autoplay = TRUE, autoplaySpeed = 1000)


# working with multiple slicks

sets <- split(
  sample(nba_team_logo$uri, size = 28, replace = FALSE),
  rep(c(1,2,3,4),each=7)
)

slicks <- lapply(sets,FUN = function(x,...){
  slickR(obj = x,...)
},height = 100)

# independent slicks

Reduce(`\%stack\%`,slicks)

# 1,2 synch stacked on 3,4 synch

 (slicks[[1]] \%synch\% slicks[[2]]) \%stack\% (slicks[[3]]\%synch\%slicks[[4]])

}
}
\seealso{
Other invoke: 
\code{\link{slickR-shiny}}
}
\concept{invoke}
