%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:19:29.
% Do NOT modify this file, instead modify the source (sma/R/RBayesian.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.bayesian}
\alias{plot.bayesian}

\title{Plots an Odds Ratio of Each Gene in a Multi-slide microarray
Experiment}
\description{
This function takes the normalized expression estimates from a
multi-slide microarray experiment (M-values output
by stat.ma) and plots an odds ratio for each gene: log( Pr(the gene is
differentially expressed) / Pr(the gene is not differentially expressed)
) vs the gene-specific average M-value. Alternatively, the output of
stat.bayesian() can be given as input. The resulting plot is the same,
but tedious calculations don't have to be done all over again.}

\usage{
plot.bayesian(X=NULL, nb=NULL, nw=1, lods=NULL, Xprep=NULL, para=list(p
= 0.01, v = NULL, a = NULL, c = NULL, k = NULL))
}

\arguments{
  \item{X}{List containing matrix of (normalized) log expression ratios
    \eqn{M = log_2 (R/G)} (E.g. output from stat.ma())}
  \item{nb}{Number of slides containing spots for a gene (common for all
  genes). Unnecessary argument if nw=1.}
  \item{nw}{Number of spots for a gene within each slide (common to all
    genes).Default is 1.}
  \item{lods}{The log odds ratio for each gene. Not necessary input. See
    details!} 
  \item{Xprep}{Some data structures useful in this graphical
    presentation. Not necessary input. See details!} 
  \item{para}{Estimates of the parameters used in the Bayesian
    calculations. Not necessary input. See details!}
}
\details{

  lods, Xprep and para are optional input. If Xprep is supplied as
  input, then X, nb and nw are unnecessary input. If lods is supplied, para
  is unnecessary. A subset of the parameters
  in para can be specified in the input, allowing the function to
  estimate only the others. 

  Xprep is a list containing
  
  \item{nb}{Number of slides containing spots for a gene (common to all
  genes).}
  \item{nw}{Number of spots for a gene within each slide (common to
  all genes).} 
  \item{Mbar}{Overalll means for each gene.}
  \item{SSB}{Sum of squares between slides for each gene.}
  \item{SSB}{Sum of squares within slides for each gene.}

  para is a list of parameters common to all genes containing

  \item{p}{Probability that a random gene is differentially
    expressed. Default is 0.01.
  \item{v,a}{Parameters in the prior for the variance. If the observed
    variances for the genes are (V), then v and a is such that
    (va/V)~Chi2(v).}
  \item{c}{Parameter in the prior for the mean expression ratio.}
  \item{k}{An approximate ratio of the variances between to within slides,
    only needed when both nw>1 and nb>1}

}

\author{
    Ingrid Lnnstedt \email{ingrid@math.uu.se} \cr
    Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
}

\seealso{\code{\link{stat.bayesian}}}

\examples{
data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
## mouse.lratio <- stat.ma(mouse.data, mouse.setup)

#Alternative 1
## mouse.bayesian<-stat.bayesian(X=mouse.lratio)
## plot.bayesian(Xprep=mouse.bayesian$Xprep, lods=mouse.bayesian$lods)

#Alternative 2
## plot.bayesian(X=mouse.lratio)

#My changes
## my.para<-mouse.bayesian$para
## my.para$p<-0.05
## plot.bayesian(Xprep=mouse.bayesian$Xprep, para=my.para)

}

\keyword{microarray, bayesian, lodsratio}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
