% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spscan.R
\name{plot.spscan}
\alias{plot.spscan}
\title{Plots object from \code{\link{spscan.test}}.}
\usage{
\method{plot}{spscan}(x, ..., nv = 100, border = NULL, ccol = NULL, clty = NULL, clwd = NULL)
}
\arguments{
\item{x}{An object of class \code{spscan}.}

\item{...}{Additional graphical parameters passed to the
\code{\link[spatstat.geom]{plot.ppp}} function.}

\item{nv}{The number of vertices when drawing the cluster 
circles. Default is 100.}

\item{border}{The border color of the circle.  Default is
NULL, meaning black.}

\item{ccol}{Fill color of the circles.  Default is NULL,
indicating empty.}

\item{clty}{Line type of circles.  Default is NULL,
indicting \code{lty = 1}.}

\item{clwd}{Line width of circles.  Default is NULL,
indicating \code{lwd = 2} for the most likely cluster and 
\code{lwd = 1} for the rest.}
}
\description{
Plots object of class \code{scan} from
\code{\link{spscan.test}}.
}
\details{
If \code{border}, \code{ccol}, \code{clty}, or 
\code{clwd} are specified, then the length of these
vectors must match \code{nrow(x$coords)}.
}
\examples{
data(grave)
out = spscan.test(grave, case = 2, alpha = 0.1, nsim = 49)
plot(out, chars = c(1, 20), main = "most likely cluster",
     border = "orange", ccol = NA)
# change color, lty, lwd of circles
set.seed(2)
out2 = spscan.test(grave, case = 2, alpha = 0.8, nsim = 49)
plot(out2, chars = c(1, 20),  border = "blue")
plot(out2, chars = c(1, 20),  border = c("blue", "orange"),
     clwd = c(3, 2), clty = c(2, 3))
}
\seealso{
\code{\link[spatstat.geom]{plot.ppp}}, \code{\link[plotrix]{draw.circle}}
}
