% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_smap.R
\name{find_smap}
\alias{find_smap}
\title{Find SMAP data}
\usage{
find_smap(id, dates, version)
}
\arguments{
\item{id}{A character string that refers to a specific SMAP dataset, e.g.,
\code{"SPL4SMGP"} for SMAP L4 Global 3-hourly 9 km Surface and Rootzone Soil
Moisture Geophysical Data. See "Details" for a list of supported data types 
and their associated id codes.}

\item{dates}{An object of class Date or a character string formatted as
%Y-%m-%d (e.g., "2016-04-01") which specifies the date(s) to search.
To search for one specific date, this can be a Date object of length one. To
search over a time interval, it can be a multi-element object of class Date
such as produced by \code{seq.Date}.}

\item{version}{Which data version would you like to search for? Version
information for each data product can be found at
\url{https://nsidc.org/data/smap/data_versions}}
}
\value{
A data.frame with the names of the data files, the remote directory, and
  the date.
}
\description{
This function searches for SMAP data on a specific date, returning a
\code{data.frame} describing available data.
}
\details{
There are many SMAP data products that can be accessed with this function.
Currently, smapr supports level 3 and level 4 data products, each of which
has an associated Data Set ID which is specified by the \code{id} argument,
described at \url{https://nsidc.org/data/smap/smap-data.html} and summarized
below:

\describe{
\item{SPL2SMAP_S}{SMAP/Sentinel-1 Radiometer/Radar Soil Moisture}
\item{SPL3FTA}{Radar Northern Hemisphere Daily Freeze/Thaw State}
\item{SPL3SMA}{Radar Global Daily Soil Moisture}
\item{SPL3SMP}{Radiometer Global Soil Moisture}
\item{SPL3SMAP}{Radar/Radiometer Global Soil Moisture}
\item{SPL4SMAU}{Surface/Rootzone Soil Moisture Analysis Update}
\item{SPL4SMGP}{Surface/Rootzone Soil Moisture Geophysical Data}
\item{SPL4SMLM}{Surface/Rootzone Soil Moisture Land Model Constants}
\item{SPL4CMDL}{Carbon Net Ecosystem Exchange}
}

This function requires a username and password from NASA's Earthdata portal.
If you have an Earthdata username and password, pass them in using the
\code{\link[=set_smap_credentials]{set_smap_credentials()}} function.

If you do not yet have a username and password, register for one here:
\url{https://urs.earthdata.nasa.gov/}
}
\examples{
\dontrun{
# looking for data on one day:
find_smap(id = "SPL4SMGP", dates = "2015-03-31", version = 4)

# searching across a date range
start_date <- as.Date("2015-03-31")
end_date <- as.Date("2015-04-02")
date_sequence <- seq(start_date, end_date, by = 1)
find_smap(id = "SPL4SMGP", dates = date_sequence, version = 4)
}

}
