% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oversampling.R
\name{oversample}
\alias{oversample}
\title{Oversampling wrapper}
\usage{
oversample(dataset, method, class_attr = "Class", ...)
}
\arguments{
\item{dataset}{we want to perform oversampling on}

\item{method}{selected method of oversampling}

\item{class_attr}{\code{character}. Indicates the class attribute or
attributes from \code{dataset}. Must exist in it.}

\item{...}{Further arguments for \code{method}}
}
\value{
An oversampled dataset
}
\description{
Oversampling wrapper
}
\examples{
library("smartdata")
data(iris0, package = "imbalance")

super_iris <- oversample(iris0, method = "MWMOTE", class_attr = "Class",
                         ratio = 0.8, filtering = TRUE)
super_iris <- oversample(iris0, method = "SMOTE", class_attr = "Class", ratio = 0.6)
super_iris <- oversample(iris0, method = "PDFOS", class_attr = "Class", ratio = 0.6)
super_iris <- oversample(iris0, method = "RWO", class_attr = "Class", ratio = 0.8)
super_iris <- oversample(iris0, method = "SLMOTE", class_attr = "Class")

}
