\name{fitted.sma}
\alias{fitted.sma}
\title{
Returns fitted values
}
\description{
Returns "fitted values" of a (standardized) major axis fit.
}
\usage{
\method{fitted}{sma}(object, type = "fitted", newdata=NULL, centered=TRUE, ...)
}
\arguments{
  \item{object}{Object of class \code{sma}.}
  \item{type}{Either 'residuals', or 'fitted'.}
  \item{newdata}{New data for which to provide fitted values.}
  \item{centered}{Logical. If TRUE (the default) returns the zero-centered fitted values.}
  \item{\dots}{Further arguments are currently ignored.}
}
\details{
"Fitted values" are calculated using \code{y+bx} for SMA or \code{by+x} for MA (see Warton et al. 2006, especially Table 4). Note these values are calculated differently to ordinary linear regression, and they cannot be interpreted as predicted values. The "fitted values" should be interpreted as measuring how far along the fitted axis each point lies, and are used in checking assumptions (via residual vs. fitted value plots).

Fitted values may be computed for new data, using the \code{newdata} arguments. Be aware that the names of the variables need to be the same as in the data used in the original model fit. Also, if the original fit used \code{log='xy'}, for example, this transformation will also be applied to your \code{newdata} (so don't do the transformation yourself).
}
\references{ Warton D. I., Wright I. J., Falster D. S. and Westoby M. (2006) A review of bivariate line-fitting methods for allometry.  \emph{Biological Reviews} \bold{81}, 259-291.
}
\seealso{
\code{\link{sma}},\code{\link{residuals.sma}}
}

\keyword{misc}

