% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcfcs.r
\name{smcfcs.nestedcc}
\alias{smcfcs.nestedcc}
\title{Substantive model compatible fully conditional specification imputation of covariates for nested case control
studies}
\usage{
smcfcs.nestedcc(originaldata, smformula, method, set, event, nrisk, ...)
}
\arguments{
\item{originaldata}{The nested case-control data set (NOT a full cohort data set with a case-cohort substudy within it)}

\item{smformula}{A formula of the form "Surv(t,case)~x+strata(set)", where case is case-control indicator, t is the event or censoring time. Note that t could be set to the case's event time for the matched controls in a given set. The right hand side should include the case control set as a strata term (see example).}

\item{method}{A required vector of strings specifying for each variable either
that it does not need to be imputed (""), the type of regression model to be
be used to impute. Possible values are \code{"norm"} (normal linear regression),
\code{"logreg"} (logistic regression), \code{"brlogreg"} (bias reduced logistic regression),
\code{"poisson"} (Poisson regression),
\code{"podds"} (proportional odds regression for ordered categorical variables),
\code{"mlogit"} (multinomial logistic regression for unordered categorical variables),
or a custom expression which defines a passively imputed variable, e.g.
\code{"x^2"} or \code{"x1*x2"}. \code{"latnorm"} indicates the variable is a latent
normal variable which is measured with error. If this is specified for a variable,
the \code{"errorProneMatrix"} argument should also be used.}

\item{set}{variable identifying matched sets in nested case-control study}

\item{event}{variable which indicates who is a case/control in the nested case-control sample. Note that this is distinct from d.}

\item{nrisk}{variable which is the number at risk (in the underlying full cohort) at the event time for the case in each matched set (i.e. nrisk is the same for all individuals in a matched set).}

\item{...}{Additional arguments to pass on to \link[smcfcs]{smcfcs}}
}
\description{
Multiply imputes missing covariate values using substantive model compatible
fully conditional specification for nested case control studies.
}
\details{
This version of \code{smcfcs} is designed for use with nested case control studies. The function's arguments are the same
as for the main smcfcs function, except for \code{smformula}, \code{set}, \code{event} and \code{nrisk} - see above
for details on how these should be specified.
}
\examples{
#the following example is not run when the package is compiled on CRAN
#(to keep computation time down), but it can be run by package users
\dontrun{
  predictorMatrix <- matrix(0,nrow=dim(ex_ncc)[2],ncol=dim(ex_ncc)[2])
  predictorMatrix[which(colnames(ex_ncc)=="x"),c(which(colnames(ex_ncc)=="z"))] <- 1

  imps <- smcfcs.nestedcc(originaldata=ex_ncc,set="setno",nrisk="numrisk",event="d",
                          smformula="Surv(t,case)~x+z+strata(setno)",
                          method=c("", "", "logreg", "", "", "", "", ""),
                          predictorMatrix=predictorMatrix)
  library(mitools)
  impobj <- imputationList(imps$impDatasets)
  models <- with(impobj, clogit(case~x+z+strata(setno)))
  summary(MIcombine(models))
}
}
\author{
Ruth Keogh \email{ruth.keogh@lshtm.ac.uk}

Jonathan Bartlett \email{jonathan.bartlett1@lshtm.ac.uk}
}
