% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smdi_hotelling.R
\name{smdi_hotelling}
\alias{smdi_hotelling}
\title{Computes hotelling's multivariate t-test}
\usage{
smdi_hotelling(data = NULL, covar = NULL, n_cores = 1)
}
\arguments{
\item{data}{dataframe or tibble object with partially observed/missing variables}

\item{covar}{character covariate or covariate vector with partially observed variable/column name(s) to investigate. If NULL, the function automatically includes all columns with at least one missing observation and all remaining covariates will be used as predictors}

\item{n_cores}{integer, if >1, computations will be parallelized across amount of cores specified in n_cores (only UNIX systems)}
}
\value{
returns a hotelling object with statistics on hotellings test by covariate. That is, for each covar, the following outputs are provided:
\itemize{
\item stats: hotelling test statistics (for more information see \code{\link{hotelling.test}})
\item pval: p-value of hotelling test
}
}
\description{
Hotelling's multivariate t-test, which examines variable
differences conditional on having an observed covariate value or not.
As the power of statistical hypothesis tests can be influenced by
sample size, the combined investigation along with smdi_asmd() is highly recommended.

Important: don't include variables like ID variables, ZIP codes, dates, etc.
}
\details{
CAVE: Hotelling's and Little's show high susceptibility with large sample sizes and it is recommended to always interpret the results along with the other diagnostics.
}
\examples{
library(smdi)

smdi_hotelling(data = smdi_data)

}
\references{
Hotelling H. The Generalization of Student’s Ratio. Ann Math Stat. 1931;2(3):360-378.
}
\seealso{
\code{\link{hotelling.test}}
}
