% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smdi_style_gt.R
\name{smdi_style_gt}
\alias{smdi_style_gt}
\title{Takes an object of class smdi and styles it to a publication-ready gt table}
\usage{
smdi_style_gt(
  smdi_object = NULL,
  include_little = TRUE,
  font_size = 13,
  tbl_width = 800
)
}
\arguments{
\item{smdi_object}{object of class "smdi" or data.frame/tibble}

\item{include_little}{can be logical (TRUE/FALSE) for displaying Little's p-value that is part of an "smdi" object or a separate object of class "little"}

\item{font_size}{integer to determine table font size}

\item{tbl_width}{integer to determine table width}
}
\value{
returns a formatted gt table object
}
\description{
This function takes either an object of class smdi or data.frame or tibble as
input and styles it to a publication-ready table based on the gt package.
The output is of class gt and can take further gt-based arguments for
customization.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(smdi)
library(dplyr)

smdi_diagnose(
  data = smdi_data,
  covar = "egfr_cat",
  model = "cox",
  form_lhs = "Surv(eventtime, status)"
  ) \%>\%
smdi_style_gt()

}
\seealso{
\code{\link{gt}}
}
