% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sm_build}
\alias{sm_build}
\title{Use \verb{AWS CodeBuild} to build docker images and push them to Amazon \code{ECR}}
\usage{
sm_build(
  repository = NULL,
  compute_type = c("BUILD_GENERAL1_SMALL", "BUILD_GENERAL1_MEDIUM",
    "BUILD_GENERAL1_LARGE", "BUILD_GENERAL1_2XLARGE"),
  role = NULL,
  dir = ".",
  bucket = NULL,
  vpc_id = NULL,
  subnet_ids = list(),
  security_group_ids = list(),
  log = TRUE,
  ...
)
}
\arguments{
\item{repository}{(character): The \code{ECR} repository:tag for the image
(default: \verb{sagemaker-studio-$\{domain_id\}:latest})}

\item{compute_type}{(character): The \href{https://aws.amazon.com/codebuild/}{\code{CodeBuild}} compute type (default: \code{BUILD_GENERAL1_SMALL})}

\item{role}{(character): The \code{IAM} role name for \code{CodeBuild} to use (default: the Studio execution role).}

\item{dir}{(character): Directory to build}

\item{bucket}{(character): The S3 bucket to use for sending data to \code{CodeBuild} (if None,
use the \verb{SageMaker SDK} default bucket).}

\item{vpc_id}{(character): The Id of the \code{VPC} that will host the \code{CodeBuild} Project
(such as \verb{vpc-05c09f91d48831c8c}).}

\item{subnet_ids}{(list): List of \code{subnet} ids for the \code{CodeBuild} Project
(such as \verb{subnet-0b31f1863e9d31a67})}

\item{security_group_ids}{(list): List of security group ids for
the \code{CodeBuild} Project (such as \verb{sg-0ce4ec0d0414d2ddc}).}

\item{log}{(logical): Show the logs of the running \code{CodeBuild} build}

\item{...}{docker build parameters
\url{https://docs.docker.com/engine/reference/commandline/build/#options}
(NOTE: use "_" instead of "-" for example: docker optional parameter
\code{build-arg} becomes \code{build_arg})}
}
\value{
\code{NULL} invisible
}
\description{
This function takes a directory containing a
\href{https://docs.docker.com/engine/reference/builder/}{dockerfile}, and builds it on
\href{https://aws.amazon.com/codebuild/}{\verb{AWS CodeBuild}}. The resulting image is
then stored in \href{https://aws.amazon.com/ecr/}{\verb{AWS ECR}} for later use.
}
\examples{
\dontrun{
# Execute on current directory.
sm_build()

# Execute on different directory.
sm_build(dir = "my-project")

# Add extra docker arguments
sm_build(
  file = "/path/to/Dockerfile",
  build_arg = "foo=bar"
)
}
}
