% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{clusters}
\alias{clusters}
\title{Extract clusters}
\usage{
clusters(x)
}
\arguments{
\item{x}{An object of class \code{smerc_cluster}.}
}
\value{
A list. Each element of the list is a vector with the indices of event
locations in the associated cluster.
}
\description{
\code{clusters} extracts the clusters contained in a
\code{\link{smerc_cluster}} object.
}
\examples{
data(nydf)
coords = with(nydf, cbind(longitude, latitude))
out = scan.test(coords = coords, cases = floor(nydf$cases),
                pop = nydf$pop, nsim = 19,
                alpha = 0.2, longlat = TRUE)
clusters(out)
}
