\name{predict.smnet}
\alias{predict.smnet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Predict From a Stream Network Model.}
\description{
Get predictions and standard errors for a new set of spatial locations and associated covariate values from a model fitted by \code{\link{smnet}}.
}
\usage{\method{predict}{smnet}(object, newdata =  NULL, ...)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{Object of class smnet, usually the result of a call to \code{smnet}.
}
\item{newdata}{New design matrix at which to make predictions}

\item{...}{other arguments passed to \code{predict.smnet}
}
}

\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
\item{predictions}{vector of predictions corresponding to prediction points in the original \code{SpatialStreamNetwork} input object}
\item{predictions.se}{vector of prediction standard errors}
%% ...
}

\author{
Alastair Rushworth
}

\seealso{
\code{\link{smnet}}
}
\examples{

# Set up an SSN object - this part taken 
# from the SSN:::SimulateOnSSN help file
example_network_5<- createSSN(
                     n          = 50,
                     obsDesign  = binomialDesign(200), 
                     predDesign = binomialDesign(50),
                     importToR  = TRUE, 
                     path = paste(tempdir(),"/example_network_5",sep = ""),
                     treeFunction = iterativeTreeLayout
                     )

# plot the simulated network structure with prediction locations
# plot(example_network_5, bty = "n", xlab = "x-coord", ylab = "y-coord")

## create distance matrices, including between predicted and observed
createDistMat(example_network_5, "preds", o.write=TRUE, amongpred = TRUE)

## extract the observed and predicted data frames
observed_data            <- getSSNdata.frame(example_network_5, "Obs")
prediction_data          <- getSSNdata.frame(example_network_5, "preds")

## associate continuous covariates with the observation locations
#  data generated from a normal distribution
obs                      <- rnorm(200)
observed_data[,"X"]      <- obs
observed_data[,"X2"]     <- obs^2

## associate continuous covariates with the prediction locations
#  data generated from a normal distribution
pred                     <- rnorm(50) 
prediction_data[,"X"]    <- pred
prediction_data[,"X2"]   <- pred^2

## simulate some Gaussian data that follows a 'tail-up' spatial process
sims <- SimulateOnSSN(
               ssn.object      = example_network_5, 
               ObsSimDF        = observed_data, 
               PredSimDF       = prediction_data,  
               PredID          = "preds",  
               formula         = ~ 1 + X,
               coefficients    = c(1, 10),
               CorModels       = c("Exponential.tailup"), 
               use.nugget      = TRUE,
               CorParms        = c(10, 5, 0.1),
               addfunccol      = "addfunccol")$ssn.object


## extract the observed and predicted data frames, now with simulated values
sim1DFpred         <- getSSNdata.frame(sims, "preds")
sim1preds          <- sim1DFpred[,"Sim_Values"]
sim1DFpred[,"Sim_Values"] <- NA
sims               <- putSSNdata.frame(sim1DFpred, sims, "preds")

# create the adjacency matrix for use with smnet
adjacency    <- get_adjacency(
                  paste(tempdir(), "/example_network_5", sep = ""), 
                  net = 1
                  )

# not run - plot the adjacency matrix
# display(adjacency[[1]])

# sometimes it is useful to see which varaibles are valid network weights 
# in the data contained within the SSN object
show_weights(sims, adjacency)

# fit a penalised spatial model to the stream network data
# Sim_Values are quadratic in the X covariate.  To highlight 
# the fitting of smooth terms, this is treated as non-linear 
# and unknown using m().
mod_smn       <- smnet(formula = Sim_Values ~ m(X) + m(X2) + 
network(adjacency = adjacency, weight = "shreve"), 
                       data.object = sims, netID = 1)

# not run - plot different summaries of the model
plot(mod_smn, type = "network-covariates")
plot(mod_smn, type = "network-segments", weight = 4, shadow = 2)
plot(mod_smn, type = "network-full", weight = 4, shadow = 2)

# obtain predictions at the prediction locations and plot 
# against true values
preds <- predict(mod_smn, newdata = getSSNdata.frame(sims, "preds"))
plot(preds$predictions, sim1preds)

# obtain summary of the fitted model
summary(mod_smn)
}

