% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addLoggingWrapper.R
\name{addLoggingWrapper}
\alias{addLoggingWrapper}
\title{Return a function which internally stores x or y values.}
\usage{
addLoggingWrapper(fn, logg.x = FALSE, logg.y = TRUE)
}
\arguments{
\item{fn}{[\code{smoof_function}]\cr
Smoof function.}

\item{logg.x}{[\code{logical(1)}]\cr
Should x-values be logged? Default is \code{FALSE}.}

\item{logg.y}{[\code{logical(1)}]\cr
Should objective values be logged? Default is \code{TRUE}.}
}
\value{
[\code{smoof_logging_function}]
}
\description{
Return a function which internally stores x or y values.
}
\note{
Logging values, in particular logging x-values, will substantially slow
down the evaluation of the function.
}
\examples{
# We first build the smoof function and apply the logging wrapper to it
fn = makeSphereFunction(dimension = 2L)
fn = addLoggingWrapper(fn, logg.x = TRUE)

# We now apply an optimization algorithm to it and the logging wrapper keeps
# track of the evaluated points.
res = optim(fn, par = c(1, 1), method = "Nelder-Mead")

# Extract the logged values
log.res = getLoggedValues(fn)
print(log.res$pars)
print(log.res$obj.vals)
log.res = getLoggedValues(fn, compact = TRUE)
print(log.res)
}

