% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snof.R
\name{snof}
\alias{snof}
\title{Helper function to create numeric single-objective optimization test function.}
\usage{
snof(name = NULL, id = NULL, par.len = NULL, par.id = "x",
  par.lower = NULL, par.upper = NULL, description = NULL, fn,
  vectorized = FALSE, noisy = FALSE, fn.mean = NULL,
  minimize = TRUE, constraint.fn = NULL, tags = character(0),
  global.opt.params = NULL, global.opt.value = NULL,
  local.opt.params = NULL, local.opt.values = NULL)
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Function name. Used for the title of plots for example.}

\item{id}{[\code{character(1)} | \code{NULL}]\cr
Optional short function identifier. If provided, this should be a short
name without whitespaces and now special characters beside the underscore.
Default is \code{NULL}, which means no ID at all.}

\item{par.len}{[\code{integer(1)}]\cr
Length of parameter vector.}

\item{par.id}{[\code{character(1)}]\cr
Optional name of parameter vector.
Default is \dQuote{x}.}

\item{par.lower}{[\code{numeric}]\cr
Vector of lower bounds. A single value of length 1 is automatically replicated
to \code{n.pars}.
Default is -Inf.}

\item{par.upper}{[\code{numeric}]\cr
Vector of upper bounds. A singe value of length 1 is automatically replicated
to \code{n.pars}.
Default is Inf.}

\item{description}{[\code{character(1)} | \code{NULL}]\cr
Optional function description.}

\item{fn}{[\code{function}]\cr
Objective function.}

\item{vectorized}{[\code{logical(1)}]\cr
Can the objective function handle \dQuote{vector} input, i.~e., does it
accept matrix of parameters? Default is \code{FALSE}.}

\item{noisy}{[\code{logical(1)}]\cr
Is the function noisy? Defaults to \code{FALSE}.}

\item{fn.mean}{[\code{function}]\cr
Optional true mean function in case of a noisy objective function. This functions should
have the same mean as \code{fn}.}

\item{minimize}{[\code{logical(1)}]\cr
Set this to \code{TRUE} if the function should be minimized and to
\code{FALSE} otherwise.
The default is \code{TRUE}.}

\item{constraint.fn}{[\code{function | NULL}]\cr
Function which returns a logical vector indicating whether certain conditions
are met or not. Default is \code{NULL}, which means, that there are no constraints
beside possible box constraints defined via the \code{par.set} argument.}

\item{tags}{[\code{character}]\cr
Optional character vector of tags or keywords which characterize the function,
e.~g. \dQuote{unimodal}, \dQuote{separable}. See \code{\link{getAvailableTags}} for
a character vector of allowed tags.}

\item{global.opt.params}{[\code{list} | \code{numeric} | \code{data.frame} | \code{matrix} | \code{NULL}]\cr
Default is \code{NULL} which means unknown. Passing a \code{numeric} vector will
be the most frequent case (numeric only functions). In this case there is only a
single global optimum. If there are multiple global optima, passing a numeric
\code{matrix} is the best choice. Passing a \code{list} or a \code{data.frame}
is necessary if your function is mixed, e.g., it expects both numeric and discrete
parameters. Internally, however, each representation is casted to a \code{data.frame}
for reasons of consistency.}

\item{global.opt.value}{[\code{numeric(1)} | \code{NULL}]\cr
Global optimum value if known. Default is \code{NULL}, which means unknown. If
only the \code{global.opt.params} are passed, the value is computed automatically.}

\item{local.opt.params}{[\code{list} | \code{numeric} | \code{data.frame} | \code{matrix} | \code{NULL}]\cr
Default is \code{NULL}, which means the function has no local optima or they are
unknown. For details see the description of \code{global.opt.params}.}

\item{local.opt.values}{[\code{numeric} | \code{NULL}]\cr
Value(s) of local optima. Default is \code{NULL}, which means unknown. If
only the \code{local.opt.params} are passed, the values are computed automatically.}
}
\description{
This is a simplifying wrapper around \code{\link{makeSingleObjectiveFunction}}.
It can be used if the function to generte is purely numeric to save some lines
of code.
}
\examples{
# first we generate the 10d sphere function the long way
fn = makeSingleObjectiveFunction(
  name = "Testfun",
  fn = function(x) sum(x^2),
  par.set = makeNumericParamSet(
    len = 10L, id = "a",
    lower = rep(-1.5, 10L), upper = rep(1.5, 10L)
  )
)

# ... and now the short way
fn = snof(
 name = "Testfun",
 fn = function(x) sum(x^2),
 par.len = 10L, par.id = "a", par.lower = -1.5, par.upper = 1.5
)
}
