% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{objFunctionGradient}
\alias{objFunctionGradient}
\title{Auxiliary function which computes the (non-smooth) gradient of the LASSO objective function with respect to \eqn{\beta}.}
\usage{
objFunctionGradient(beta, X, y, lambda)
}
\arguments{
\item{beta}{The \eqn{p}-vector of coefficients.}

\item{X}{The data matrix of dimensions \eqn{n \times p}.}

\item{y}{The \eqn{n}-vector of responses.}

\item{lambda}{The LASSO regularization parameter.}
}
\value{
The value of the gradient of the LASSO objective function at \eqn{\beta}.
}
\description{
Auxiliary function which computes the (non-smooth) gradient of the LASSO objective function with respect to \eqn{\beta}.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
beta <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% beta
lambda <- 1
print(objFunctionGradient(beta,X,y,lambda))

}
