% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop-crumbs.r
\name{drop_crumbs}
\alias{drop_crumbs}
\title{Remove small polygons or line segments}
\usage{
drop_crumbs(x, threshold, drop_empty = TRUE)
}
\arguments{
\item{x}{spatial features; lines or polygons from either the \code{sf} or \code{sp}
packages.}

\item{threshold}{an area or length threshold, below which features will be
removed. Provided either as a \code{units} object (see \code{\link[units:set_units]{units::set_units()}}), or
a numeric threshold in the units of the coordinate reference system. If \code{x}
is in unprojected coordinates, a numeric threshold is assumed to be in
meters.}

\item{drop_empty}{logical; whether features with sizes below the given
threshold should be removed (the default) or kept as empty geometries. Note
that \code{sp} objects cannot store empty geometries, so this argument will be
ignored and empty geometries will always be removed.}
}
\value{
A spatial feature, with small pieces removed, in the same format as
the input data. If none of the features are larger than the threshold,
\code{sf} inputs will return a geometry set with zero features, and \code{sp} inputs
will return \code{NULL}.
}
\description{
Remove polygons or line segments below a given area or length threshold.
}
\details{
For multipart features, the removal threshold is applied to the individual
components. This means that, in some cases, an entire feature may be removed,
while in other cases, only parts of the multipart feature will be removed.
}
\examples{
# remove polygons smaller than 200km2
p <- jagged_polygons$geometry[7]
area_thresh <- units::set_units(200, km^2)
p_dropped <- drop_crumbs(p, threshold = area_thresh)
# plot
par(mar = c(0, 0, 1, 0), mfrow = c(1, 2))
plot(p, col = "black", main = "Original")
plot(p_dropped, col = "black", main = "After drop_crumbs()")

# remove lines less than 25 miles
l <- jagged_lines$geometry[8]
# note that any units can be used
# conversion to units of projection happens automatically
length_thresh <- units::set_units(25, miles)
l_dropped <- drop_crumbs(l, threshold = length_thresh)
# plot
par(mar = c(0, 0, 1, 0), mfrow = c(1, 2))
plot(l, lwd = 5, main = "Original")
plot(l_dropped, lwd = 5, main = "After drop_crumbs()")
}
