# nolint start: line_length_linter

.msg_en <- list(
    unsupported_input_type = "Unsupported input type '%s'",
    check_array_invalid_dims = "argument '%s' must have 3 dimensions (height, width, bands)",
    check_array_must_be_numeric = "argument '%s' must be numeric",
    array_no_projection_support = "Array inputs do not support spatial projection",
    grid_unable_determine_seed_counts = "Unable to determine seed counts",
    grid_no_valid_seed_positions = "Spacing/padding combination yields no valid seed positions",
    terra_required = "Package 'terra' must be installed to handle SpatRaster input",
    terra_check_invalid_raster = "argument '%s' must be a SpatRaster object",
    manual_grid_interactive_only = "'snic_grid_manual()' can only be used in an interactive R session",
    manual_grid_instructions = "Left-click to add points; press ESC or right-click to stop.",
    raster_invalid_index = "invalid band index; raster has %d bands.",
    plot_core_invalid_x = "argument 'x' is not a SpaceRaster",
    magick_required = "Package 'magick' must be installed to produce GIF animations",
    max_frames_positive_integer = "argument 'max_frames' must be a strictly positive integer",
    delay_positive_number = "argument 'delay' must be a positive number",
    progress_must_be_logical = "argument 'progress' must be a single logical value",
    file_path_single_path = "argument 'file_path' must be a single path",
    file_path_required = "argument 'file_path' must be provided",
    animation_file_exists = "Output file '%s' already exists; refusing to overwrite",
    animation_dir_create_failed = "Unable to create directory '%s'",
    animation_saved = "Saved animation to %s (%.1f s, %.1f fps)",
    grid_img_min_dimensions = "argument 'x' must have at least one row and one column",
    grid_spacing_numeric = "argument 'spacing' must be numeric",
    grid_spacing_finite = "argument 'spacing' must contain only finite values",
    grid_spacing_greater_than_one = "argument 'spacing' must be greater than 1",
    grid_spacing_length = "argument 'spacing' must have length 1 or 2",
    grid_padding_numeric = "argument 'padding' must be numeric",
    grid_padding_finite = "argument 'padding' must contain only finite values",
    grid_padding_length = "argument 'padding' must have length 1 or 2",
    grid_padding_non_negative = "argument 'padding' must be non-negative",
    grid_padding_no_space = "argument 'padding' leaves no room for seed placement",
    grid_type_invalid = "argument 'type' is invalid",
    seeds_cannot_be_null = "argument 'seeds' cannot be NULL",
    seeds_columns_lonlat_or_rc = "argument 'seeds' must have columns (lon, lat) or (r, c)",
    seeds_check_matrix_two_columns = "argument 'seeds' must have exactly two columns",
    seeds_invalid_type = "argument 'seeds' must be a data frame or matrix with columns 'r' and 'c'",
    seeds_must_have_coordinates = "argument 'seeds' must contain at least one coordinate",
    seeds_type_mismatch = "Cannot append seeds of a different coordinate type",
    img_data_pointer_null = "Image data pointer must not be null",
    img_dimensions_not_positive = "Image width and height must be positive",
    img_bands_not_positive = "Number of bands must be positive",
    order_invalid = "argument 'order' must be either 'C' (row-major) or 'F' (column-major)",
    image_too_large = "Image too large",
    internal_segmentation_length_mismatch = "Internal error: segmentation length mismatch",
    img_must_be_numeric_array = "argument 'x' must be a numeric array",
    img_must_have_dimensions = "argument 'x' must have dimensions",
    img_must_be_numeric_array_three_dimensions = "argument 'x' must be a numeric array with three dimensions",
    img_dimensions_positive_integers = "argument 'x' dimensions must be positive integers",
    compactness_must_be_numeric_scalar = "argument 'compactness' must be a numeric scalar",
    compactness_non_negative_finite = "argument 'compactness' must be a non-negative finite number",
    order_single_character = "argument 'order' must be a single character string",
    img_all_na = "All pixels contain NA values; SNIC cannot segment.",
    seeds_required = "argument 'seeds' must be provided",
    seeds_must_be_integer_matrix = "argument 'seeds' must be an integer matrix",
    seeds_must_have_dimensions = "argument 'seeds' must have dimensions",
    seeds_two_columns_exact = "argument 'seeds' must have two columns (row, column)",
    seeds_length_mismatch = "argument 'seeds' length mismatch",
    seeds_no_na_coordinates = "argument 'seeds' cannot contain NA coordinates",
    seeds_coordinates_within_bounds = "argument 'seeds' coordinates must lie within image bounds",
    snic_args_must_be_list = "argument 'snic_args' must be a list",
    img_must_be_atomic = "'x' must be an atomic R object",
    newdim_must_be_integer_vector = "'newdim' must be an integer vector",
    newdim_must_have_dimension = "'newdim' must contain at least one dimension",
    newdim_non_positive = "'newdim' contains non-positive value at position %s",
    newdim_product_mismatch = "Product of 'newdim' (%s) does not match object length (%s)",
    image_must_contain_pixel = "Image must contain at least one pixel",
    mask_size_mismatch = "Mask size mismatch for image size",
    snic_no_seeds = "No seeds provided for SNIC segmentation",
    seed_index_out_of_bounds = "Seed index out of bounds for provided image dimensions",
    seeds_all_on_na = "All seeds fall on pixels containing NA values; SNIC cannot segment.",
    snic_expected_class = "argument 'x' must be an object created by snic()",
    snic_expected_list = "argument 'seg' must be a list",
    snic_expected_seg = "argument 'seg' must have an element named 'seg'"
)

# nolint end
