% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{snowflake_connection}
\alias{snowflake_connection}
\title{Snowflake connection parameter configuration}
\usage{
snowflake_connection(name = NULL, ..., .config_dir = NULL)
}
\arguments{
\item{name}{A named connection. Defaults to
\verb{$SNOWFLAKE_DEFAULT_CONNECTION_NAME} if set, the \code{default_connection_name}
from the \code{config.toml} file (if present), and finally the \verb{[default]}
section of the \code{connections.toml} file, if any. See \href{https://docs.snowflake.com/en/developer-guide/python-connector/python-connector-connect#setting-a-default-connection}{Snowflake's documentation}
for details.}

\item{...}{Additional connection parameters. See \strong{Common parameters}.}

\item{.config_dir}{The directory to search for a \code{connections.toml} and
\code{config.toml} file. Defaults to \verb{$SNOWFLAKE_HOME} or \verb{~/.snowflake} if that
directory exists, otherwise it falls back to a platform-specific default.
See \href{https://docs.snowflake.com/en/developer-guide/python-connector/python-connector-connect#connecting-using-the-connections-toml-file}{Snowflake's documentation}
for details.}
}
\value{
An object of class \code{"snowflake_connection"}.
}
\description{
Reads Snowflake connection parameters from the \code{connections.toml} and
\code{config.toml} files used by the \href{https://docs.snowflake.com/en/developer-guide/python-connector/python-connector-connect}{Snowflake Connector for Python}
and the \href{https://docs.snowflake.com/en/developer-guide/snowflake-cli/connecting/configure-connections}{Snowflake CLI},
or specifies them for a connection manually.
}
\section{Common parameters}{
The following is a list of common connection parameters. A more complete list
can be found in the \href{https://docs.snowflake.com/en/developer-guide/python-connector/python-connector-api#label-snowflake-connector-methods-connect}{documentation for the Snowflake Connector for Python}:
\itemize{
\item \code{account}: A Snowflake account identifier.
\item \code{user}: A Snowflake username.
\item \code{role}: The role to use for the connection.
\item \code{schema}: The default schema to use for the connection.
\item \code{database}: The default database to use for the connection.
\item \code{warehouse}: The default warehouse to use for the connection.
\item \code{authenticator}: The authentication method to use for the connection.
\item \code{private_key} or \code{private_key_file}: A path to a PEM-encoded private key
for key-pair authentication.
\item \code{private_key_file_pwd}: The passphrase for the private key, if any.
\item \code{token}: The OAuth token to use for authentication.
\item \code{token_file_path}: A path to an OAuth token to use for authentication.
\item \code{password}: The user's Snowflake password.
}
}

\examples{
\dontshow{if (has_a_default_connection()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read the default connection parameters from an existing
# connections.toml file:
conn <- snowflake_connection()

# Read a named connection from an existing connections.toml file:
conn <- snowflake_connection(name = "default")

# Override specific parameters for a connection:
conn <- snowflake_connection(
  schema = "myschema",
  warehouse = "mywarehouse"
)
\dontshow{\}) # examplesIf}
# Pass connection parameters manually, which is useful if there is no
# connections.toml file. For example, to use key-pair authentication:
conn <- snowflake_connection(
  account = "myaccount",
  user = "me",
  private_key = "rsa_key.p8"
)
}
