% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerRelation.R
\name{coalitionsAreIndifferent}
\alias{coalitionsAreIndifferent}
\title{Are coalitions indifferent}
\usage{
coalitionsAreIndifferent(powerRelation, c1, c2)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{c1}{Coalition \link[base:c]{vector} or \code{\link[sets:set]{sets::set()}}}

\item{c2}{Coalition \link[base:c]{vector} or \code{\link[sets:set]{sets::set()}}}
}
\value{
Logical value \code{TRUE} if \code{c1} and \code{c2} are in the same equivalence class, else \code{FALSE}.
}
\description{
Check if coalitions are indifferent from one another, or, if they appear in the same
equivalence class.
}
\details{
\code{\link[=equivalenceClassIndex]{equivalenceClassIndex()}} is called to determine, which equivalence class \code{c1} and \code{c2}
belong to. It returns \code{TRUE} if both are in the same equivalence class.

If either coalition \code{c1} or \code{c2} is not part of the power relation, an error is thrown.
}
\examples{
pr <- newPowerRelation(c(1,2), ">", c(1), "~", c(2))

# FALSE
coalitionsAreIndifferent(pr, c(1,2), c(1))

# TRUE
coalitionsAreIndifferent(pr, 2, 1)

# Error: The coalition {} does not appear in the power relation
tryCatch(
  equivalenceClassIndex(pr, c()),
  error = function(e) { e }
)

}
\seealso{
Other equivalence class lookup functions: 
\code{\link{equivalenceClassIndex}()}
}
\concept{equivalence class lookup functions}
