% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{powerRelationGenerator}
\alias{powerRelationGenerator}
\title{Generate power relations}
\usage{
powerRelationGenerator(coalitions, startWithLinearOrder = FALSE)
}
\arguments{
\item{coalitions}{List of coalition vectors. An empty coalition can be set with \code{c()}.}

\item{startWithLinearOrder}{If set to \code{TRUE}, the first \code{\link{PowerRelation}} object generated will be a linear order in the order of the list of \code{coalitions} they are given.
If set to \code{FALSE}, the first \code{\link{PowerRelation}} object generated will have a single equivalence class containing all coalitions, as in, every coalition is equally powerful.}
}
\value{
A generator function.
Every time this generator function is called, a different \code{\link{PowerRelation}} object is returned.
Once all possible power relations have been generated, the generator function returns \code{NULL}.
}
\description{
Based on a list of coalitions, create a generator function that returns a new \code{\link{PowerRelation}} object with every call.
\code{NULL} is returned once every possible power relation has been generated.
}
\details{
Using the \code{partitions} library, \code{\link[partitions:parts]{partitions::compositions()}} is used to create all possible partitions over the set of coalitions.
For every partition, \code{\link[partitions:parts]{partitions::multinomial()}} is used to create all permutations over the order of the coalitions.

Note that the number of power relations (or total preorders) grows incredibly fast.

The Stirling number of second kind \eqn{S(n,k)}{S(n,k)} gives us the number of \eqn{k}{k} partitions over \eqn{n}{n} elements.

\deqn{S(n,k) = \frac{1}{k!}\sum_{j=0}^{k} (-1)^j \binom{k}{j}(k-j)^n}{S(n,k) = 1/k! * sum_(j=0)^(k) -1^j binom(k,j) (k-j)^n}

For example, with 4 coalitions (n = 4) there are 6 ways to split it into k = 3 partitions.
The sum of all partitions of any size is also known as the Bell number (\eqn{B_n = \sum_{k=0}^n S(n,k)}{B_n = S(n,0) + S(n,1) + ... + S(n,n)}, see also \code{\link[numbers:bell]{numbers::bell()}}).

Regarding total preorders \eqn{\mathcal{T}(X)}{T(X)} over a set \eqn{X}{X}, the Stirling number of second kind can be used to determine the number of all possible total preorders \eqn{|\mathcal{T}(X)|}{|T(X)|}.

\deqn{|\mathcal{T}(X)| = \sum_{k=0}^{|X|} k! * S(|X|, k)}{|T(X)| = Sum_{k=0}^{|X|} k! * S(|X|, k)}

In literature, it is referred to as the ordered Bell number or Fubini number.

In the context of social rankings we may consider total preorders over the set of coalitions \eqn{2^N}{2^N} for a given set of elements or players \eqn{N}{N}.
Here, the number of coalitions doubles with every new element.
The number of preorders then are:\tabular{llll}{
   # of elements \tab # of coalitions \tab # of total preorders \tab 1ms / computation \cr
   0 \tab 1 \tab 1 \tab 1ms \cr
   1 \tab 2 \tab 3 \tab 3ms \cr
   2 \tab 4 \tab 75 \tab 75ms \cr
   3 \tab 7 (w/o empty set) \tab 47,293 \tab 47 seconds \cr
   3 \tab 8 \tab 545,835 \tab 9 minutes \cr
   4 \tab 15 (w/o empty set) \tab 230,283,190,977,853 \tab 7,302 years \cr
   4 \tab 16 \tab 5,315,654,681,981,355 \tab 168,558 years \cr
}
}
\examples{
coalitions <- createPowerset(c('a','b'), includeEmptySet = FALSE)
# list(c('a','b'), 'a', 'b')

gen <- powerRelationGenerator(coalitions)

while(!is.null(pr <- gen())) {
  print(pr)
}
# (ab ~ a ~ b)
# (ab ~ a) > b
# (ab ~ b) > a
# (a ~ b) > ab
# ab > (a ~ b)
# a > (ab ~ b)
# b > (ab ~ a)
# ab > a > b
# ab > b > a
# a > ab > b
# b > ab > a
# a > b > ab
# b > a > ab

# from now on, gen() always returns NULL
gen()
# NULL

# Use generateNextPartition() to skip certain partitions
gen <- powerRelationGenerator(coalitions)

gen <- generateNextPartition(gen)
gen <- generateNextPartition(gen)
gen()

}
\seealso{
Other generator functions: 
\code{\link{generateNextPartition}()}
}
\concept{generator functions}
