% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seriesExtent.R
\name{seriesExtent}
\alias{seriesExtent}
\title{Retrieve Soil Series Extent Maps from SoilWeb}
\usage{
seriesExtent(s, type = c("vector", "raster"), timeout = 60)
}
\arguments{
\item{s}{a soil series name, case-insensitive}

\item{type}{series extent representation, \code{vector} results in a \code{SpatialPolygonsDataFrame} object and \code{raster} results in a \code{raster} object}

\item{timeout}{time that we are willing to wait for a response, in seconds}
}
\description{
This function downloads a generalized representations of a soil series extent from SoilWeb, derived from the current SSURGO snapshot. Data can be returned as vector outlines (\code{sf} object) or gridded representation of area proportion falling within 800m cells (\code{SpatRaster} object). Gridded series extent data are only available in CONUS. Vector representations are returned with a GCS/WGS84 coordinate reference system and raster representations are returned with an Albers Equal Area / NAD83 coordinate reference system (\code{EPSG:5070}).
}
\note{
This function requires the \code{rgdal} package.
}
\examples{
  
\donttest{
if(requireNamespace("curl") &
   requireNamespace("sf") &
   requireNamespace("terra") &
   curl::has_internet()) {
  
  # required packages
  library(sf)
  library(terra)
  
  # specify a soil series name
  s <- 'magnor'
  
  # return an sf object
  x <- seriesExtent(s, type = 'vector')
  
  # return a terra SpatRasters
  y <- seriesExtent(s, type = 'raster')
  
  if (!is.null(x) && !is.null(y)) {
    # note that CRS are different
    sf::st_crs(x)
    terra::crs(y)
  
    # transform vector representation to CRS of raster
    x <- sf::st_transform(x, terra::crs(y))
  
    # graphical comparison
    par(mar = c(1, 1 , 1, 3))
    plot(y, axes = FALSE)
    
    # no fill color
    plot(x['series'], add = TRUE, col = NA)
  }
  
}
}

}
\references{
\url{https://casoilresource.lawr.ucdavis.edu/see/}
}
\author{
D.E. Beaudette
}
