% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/solar.lib.R
\name{solarKinship2}
\alias{solarKinship2}
\title{Compute empirical double kinship matrix by SOLAR}
\usage{
solarKinship2(df, dir, ...)
}
\arguments{
\item{df}{A data frame that containts both phenotype and pedigree data.
To be passed to \code{df2solar} function.}

\item{dir}{(optional) A character with path to a directory, where SOLAR files to be created.
If this argument is missing, a temporary folder is created and further removed, when the job is done.
To be passed to \code{df2solar} function.}

\item{...}{Additional arguments to be passed to \code{df2solar}.}
}
\description{
The function runs SOLAR to evaluate the double kinship matirx of the given data.
}
\details{
The function (1) puts the data \code{df}
in SOLAR format, (2) separates it into
two parts, pedigree and phenotypes,
and then (3) expots both data sets in
the directory \code{dir},
(4) read the specific `phi2.gz` file,
where the kinship coefficients multiplied
by 2 are stored by SOLAR.
}
\note{
IDs in \code{df} are assumed to be not duplicated.
}

