% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Azimuth.R
\name{Azimuth}
\alias{Azimuth}
\title{Solar Azimuth Angle}
\usage{
Azimuth(DOY, Lat, Lon, SLon, DS)
}
\arguments{
\item{DOY}{Day of year}

\item{Lat}{Latitude (in degrees)}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}
}
\description{
This function returns solar azimuth angle (in degrees) for a given day of year and location. The solar azimuth angle is the angle of sun's ray measured in the horizental plane from due south
}
\examples{

#Calculating solar azimuth angle for two consecutive days on 45 degree lat and 10 degree lon

DOY <- seq(0, 2, .05)

Az <- Azimuth(DOY, Lat = 45, Lon=10, SLon=10, DS=0)
#Note: only the difference between Lon and SLon matters not each value

plot(DOY, Az)

}
\keyword{Azimuth}
