\name{augment}
\alias{augment}
\docType{data}
\title{
augment design example.
}
\description{
This dataset contains phenotpic data for one trait evaluated in the experimental design known as augmented design. This model allows to obtain BLUPs for genotypes that are unreplicated by dividing the field in blocks and replicating 'check genotypes' in the blocks and unreplicated genotypes randomly within the blocks. The presence of check genotypes (usually cultivars) allows the adjustment of unreplicated genotypes.

}
\usage{data("augment")}
\format{
  The format is:
 chr "augment"
}
\source{
This data was generated by a potato study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### AUGMENTED DESIGN EXAMPLE
####=========================================####
data(augment)
head(augment)
####=========================================####
#### fit the mixed model and check summary
####=========================================####
mix1 <- mmer2(TSW ~ Check.Gen, random = ~ Block + Genotype:Check, data=augment)
summary(mix1)
blup <- mix1$u.hat$`Genotype:Check`
####=========================================####
#### get only the blups for unreplicated genotypes
####=========================================####
blup2 <- blup[grep("Check1",rownames(blup)),]

}
\keyword{datasets}
\seealso{The core function of the package \code{\link{mmer}}}
