\name{DT_halfdiallel}
\alias{DT_halfdiallel}
\docType{data}
\title{
half diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 21 corn hybrids, with 2 technical repetitions, coming from a half diallel design and evaluated for sugar content. The column geno indicates the hybrid and male and female origin columns are included as well.

}
\usage{data("DT_halfdiallel")}
\format{
  The format is:
 chr "DT_halfdiallel"
}
\source{
This data was generated by a corn study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{

####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####

data("DT_halfdiallel")
DT <- DT_halfdiallel
head(DT)
DT$femalef <- as.factor(DT$female)
DT$malef <- as.factor(DT$male)
DT$genof <- as.factor(DT$geno)

A <- diag(7); colnames(A) <- rownames(A) <- 1:7;A # if you want to provide a covariance matrix
#### model using overlay
modh <- mmes(sugar~1, 
             random=~vsm(ism(overlay(femalef,malef, sparse = FALSE)), Gu=A) 
             + genof,
             data=DT)
summary(modh)$varcomp

# if ussing mmes=TRUE provide Gu with inverses
# Ai <- solve(A + diag(1e-4,ncol(A),ncol(A)))
# Ai <- as(as(as( Ai,  "dMatrix"), "generalMatrix"), "CsparseMatrix")

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmes}} }
