% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_goldstein_price.R
\name{generate_goldstein_price_function}
\alias{generate_goldstein_price_function}
\title{Generator for the Goldstein-Price function.}
\usage{
generate_goldstein_price_function()
}
\value{
A \code{soo_function}.
}
\description{
The definition used is
}
\details{
\deqn{f(x) = \left(1 + \left(x_1 + x_2 + 1\right)^2 \left(19 - 14x_1 + 13x_1^2 - 14x_2 + 6x_1x_2 + 3x_2^2\right)\right)\left(30 + \left(2x_1 - 3x_2\right)^2\left(18 - 32x_1 + 12x_1^2 + 48x_2 - 36x_1x_2 + 27x_2^2\right)\right)}
}
\examples{
f <- generate_goldstein_price_function()
plot(f, rank=TRUE)

}
\references{
Goldstein, A. A. and Price, I. F. On descent from local minima,
  Mathematics of Computation 25, 569-574, 1971.
}
