% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_issue_api.R
\name{gh_issue_stats}
\alias{gh_issue_stats}
\title{GitHub issues statistics}
\usage{
gh_issue_stats(
  owner = "ropengov",
  repo = "geofi",
  issue.type = NA,
  time.from = NA,
  time.to = NA
)
}
\arguments{
\item{owner}{Repository owner / organization. Default is "ropengov"}

\item{repo}{Repository name. Default is "geofi"}

\item{issue.type}{Type of issues printed: "issue", "PR" or NA printing all 
(default).}

\item{time.from}{Start date in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ.
Default is "2010-09-01T00:00:00Z".}

\item{time.to}{End date in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ. Default
is \code{Sys.time()}.}
}
\value{
tibble
}
\description{
Get statistics about GitHub issues from GitHub API.
}
\details{
This function is intended for easy information retrieval about rOpenGov 
package issues and pull requests. More specifically, this function returns
a tibble containing information on issue id, title, status (open or closed),
number of comments, who opened it, when it was created, what was the openers
status (rOpenGov organization member, package contributor or a regular user 
who opened e.g. a bug issue) and what is the type of the issue. 

GitHub Issues API handles Pull Requests and Issues similarly and therefore 
this function returns both types by default. Different types of issues 
can be filtered by using the issue.type parameter.

Kudos for this function go to Jennifer Bryan. The changes made here are
mostly related to adding additional fields (opener_type, issue_type) to
the output tibble and writing a function around these original contributions.
The scope of this function is to mainly help rOpenGov team analyze the type
of user feedback we get via GitHub issues and therefore the scope of this
function is very limited.
}
\seealso{
GitHub Issues API documentation: 
\url{https://docs.github.com/en/rest/reference/issues}

Original "analyze GitHub stuff with R" repository:
\url{https://github.com/jennybc/analyze-github-stuff-with-r}
}
\author{
Original scripts by Jennifer Bryan (jennybc), function by Pyry Kantanen <pyry.kantanen@gmail.com>
}
