% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{merge.soundcorrs}
\alias{merge.soundcorrs}
\title{Merge two or more \code{\link{soundcorrs}} objects.}
\usage{
\method{merge}{soundcorrs}(...)
}
\arguments{
\item{...}{[soundcorrs] Objects to be merged.}
}
\value{
[soundcorrs] The single, merged object.
}
\description{
Take multiple \code{\link{soundcorrs}} objects and combine them into one.
}
\examples{
# path to sample data in the "wide format"
fNameData <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
# path to a sample transcription
fNameTrans <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
ger <- read.soundcorrs (fNameData, "German", "ALIGNED.German", fNameTrans)
pol <- read.soundcorrs (fNameData, "Polish", "ALIGNED.Polish", fNameTrans)
merge (ger, pol)
}
