% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{list.depth}
\alias{list.depth}
\title{Measure the depth of a nested list.}
\usage{
list.depth(x, d = 0)
}
\arguments{
\item{x}{[list] The list whose depth is to be gauged.}

\item{d}{[integer] A technical variable, not supposed to be defined by the user. Defaults to \code{0}.}
}
\value{
[integer] The depth of \code{x}.
}
\description{
Check how many levels of nesting there are in a list.
}
\details{
Checks how many times a list is nested. The function is recursive, but to save on execution time it doesn't have an elegant wrapper around it and has the argument \code{d} which collects the result, and which the user is supposed not to tinker with.
}
\examples{
soundcorrs:::list.depth (list (1))
soundcorrs:::list.depth (list (list (1, list(2))))
}
\keyword{internal}
