% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{getIntegerRandomWalk}
\alias{getIntegerRandomWalk}
\title{Discrete random walk}
\usage{
getIntegerRandomWalk(rw, nonlinBalance = 50, minLength = 50, plot = FALSE)
}
\arguments{
\item{rw}{a random walk generated by \code{\link{getRandomWalk}} (expected
range 0 to 100)}

\item{nonlinBalance}{a number between 0 to 100: 0 = returns all zeros;
100 = returns all twos}

\item{minLength}{the mimimum length of each epoch}

\item{plot}{if TRUE, plots the random walk underlying nonlinear regimes}
}
\value{
Returns a vector of integers (0/1/2) of the same length as rw.
}
\description{
Internal soundgen function.
}
\details{
Takes a continuous random walk and converts it to continuous epochs of
repeated values 0/1/2, each at least minLength points long. 0/1/2 correspond
to different noise regimes: 0 = no noise, 1 = subharmonics, 2 = subharmonics
and jitter/shimmer.
}
\examples{
rw = soundgen:::getRandomWalk(len = 100, rw_range = 100, rw_smoothing = .2)
r = soundgen:::getIntegerRandomWalk(rw, nonlinBalance = 75,
                                     minLength = 10, plot = TRUE)
r = soundgen:::getIntegerRandomWalk(rw, nonlinBalance = 15,
                                     minLength = 10, plot = TRUE)
}
\keyword{internal}
