% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{notesDict}
\alias{notesDict}
\title{Conversion table from Hz to semitones above C0 to musical notation}
\format{An object of class \code{data.frame} with 132 rows and 2 columns.}
\usage{
notesDict
}
\description{
A dataframe of 132 rows and 2 columns: "note" and "freq" (Hz)
}
\examples{
# To recompile:
notes = c('C', 'C\\U266F', 'D', 'D\\U266F', 'E', 'F', 'F\\U266F', 'G', 'G\\U266F', 'A', 'B\\U266D', 'B')
nOct = 11
notes_all = paste0(notes, rep(0:(nOct - 1), each = 12))
# 440 / 32 = 13.75  # A-1, and C0 is 3 semitones higher: 16.3516 Hz exactly.
c0 = 13.75 * 2 ^ (3 / 12)
notes_freq = round (c0 * 2^(0:(12 * nOct - 1) / 12), 1)
}
\keyword{datasets}
