% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants.R
\name{reformatFormants}
\alias{reformatFormants}
\title{Reformat formants}
\usage{
reformatFormants(formants)
}
\arguments{
\item{formants}{either a character string like "aoiu" or a list with an entry
for each formant}
}
\description{
Internal soundgen function.
}
\details{
Checks that the formants are formatted in a valid way and expands them to a
standard list of dataframes with time, frequency, amplitude, and bandwidth of
each formant specified explicitly.
}
\examples{
formants = soundgen:::reformatFormants('aau')
formants = soundgen:::reformatFormants(c(500, 1500, 2500))
formants = soundgen:::reformatFormants(list(f1 = 500, f2 = c(1500, 1700)))
formants = soundgen:::reformatFormants(list(
     f1 = list(freq = 800, amp = 30),
     f2 = list(freq = c(1500, 1700, 2200), width = c(100, 150, 175))
))
}
