% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_segment.R
\name{findBursts}
\alias{findBursts}
\title{Find bursts}
\usage{
findBursts(envelope, timestep, interburst, burstThres, peakToTrough,
  troughLeft = TRUE, troughRight = FALSE)
}
\arguments{
\item{envelope}{downsampled amplitude envelope}

\item{timestep}{time difference between two points in the envelope (ms)}

\item{interburst}{minimum time between two consecutive bursts (ms). If
specified, it overrides \code{interburstMult}}

\item{burstThres}{to qualify as a burst, a local maximum has to be at least
\code{burstThres} times the height of the global maximum of amplitude
envelope}

\item{peakToTrough}{to qualify as a burst, a local maximum has to be at
least \code{peakToTrough} times the local minimum on the LEFT over
analysis window (which is controlled by \code{interburst} or
\code{interburstMult})}

\item{troughLeft}{should local maxima be compared to the trough
on the left and/or right of it? Default to TRUE and FALSE, respectively}

\item{troughRight}{should local maxima be compared to the trough
on the left and/or right of it? Default to TRUE and FALSE, respectively}
}
\value{
Returns a dataframe with timing of bursts
}
\description{
Internal soundgen function.
}
\details{
Called by \code{\link{segment}}.
}
\keyword{internal}
