% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchPars.R
\name{matchPars}
\alias{matchPars}
\title{Match soundgen pars (experimental)}
\usage{
matchPars(target, samplingRate = NULL, pars = NULL, init = NULL,
  method = c("cor", "cosine", "pixel", "dtw"), probMutation = 0.25,
  stepVariance = 0.1, maxIter = 50, minExpectedDelta = 0.001,
  windowLength = 40, overlap = 50, step = NULL, verbose = TRUE,
  padWith = NA, penalizeLengthDif = TRUE, throwaway = -120,
  maxFreq = NULL)
}
\arguments{
\item{target}{the sound we want to reproduce using soundgen: path to a .wav
file or numeric vector}

\item{samplingRate}{sampling rate of \code{target} (only needed if target is
a numeric vector, rather than a .wav file)}

\item{pars}{arguments to \code{\link{soundgen}} that we are attempting to
optimize}

\item{init}{a list of initial values for the optimized parameters \code{pars}
and the values of other arguments to soundgen that are fixed at non-default
values (if any)}

\item{method}{method of comparing mel-transformed spectra of two sounds:
"cor" = average Pearson's correlation of mel-transformed spectra of
individual FFT frames; "cosine" = same as "cor" but with cosine similarity
instead of Pearson's correlation; "pixel" = absolute difference between
each point in the two spectra; "dtw" = discrete time warp with
\code{\link[dtw]{dtw}}}

\item{probMutation}{the probability of a parameter mutating per iteration}

\item{stepVariance}{scale factor for calculating the size of mutations}

\item{maxIter}{maximum number of mutated sounds produced without improving
the fit to target}

\item{minExpectedDelta}{minimum improvement in fit to target required to
accept the new sound candidate}

\item{windowLength}{length of FFT window, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{verbose}{if TRUE, plays back the accepted candidate at each iteration
and reports the outcome}

\item{padWith}{compared spectra are padded with either silence (\code{padWith
= 0}) or with NA's (\code{padWith = NA}) to have the same number of
columns. When the sounds are of different duration, padding with zeros
rather than NA's improves the fit to target measured by \code{method =
'pixel'} and \code{'dtw'}, but it has no effect on \code{'cor'} and
\code{'cosine'}.}

\item{penalizeLengthDif}{if TRUE, sounds of different length are considered
to be less similar; if FALSE, only the overlapping parts of two sounds are
compared}

\item{throwaway}{parts of the spectra quieter than \code{throwaway} dB are
not compared}

\item{maxFreq}{parts of the spectra above \code{maxFreq} Hz are not compared}
}
\value{
Returns a list of length 2: \code{$history} contains the tried
  parameter values together with their fit to target (\code{$history$sim}),
  and \code{$pars} contains a list of the final - hopefully the best -
  parameter settings.
}
\description{
Attempts to find settings for \code{\link{soundgen}} that will reproduce an
existing sound. The principle is to mutate control parameters, trying to
improve fit to target. The currently implemented optimization algorithm is
simple hill climbing. Disclaimer: this function is experimental and may or
may not work for particular tasks. It is intended as a supplement to - not
replacement of - manual optimization. See the vignette on sound generation
for more information.
}
\examples{
playback = c(TRUE, FALSE)[2]  # set to TRUE to play back the audio from examples

target = soundgen(repeatBout = 3, sylLen = 120, pauseLen = 70,
  pitchAnchors = c(300, 200),
  rolloff = -5, play = playback)  # we hope to reproduce this sound

\dontrun{
# Match pars based on acoustic analysis alone, without any optimization.
# This *MAY* match temporal structure, pitch, and stationary formants
m1 = matchPars(target = target,
               samplingRate = 16000,
               maxIter = 0,  # no optimization, only acoustic analysis
               verbose = playback)
cand1 = do.call(soundgen, c(m1$pars, list(play = playback, temperature = 0)))

# Try to improve the match by optimizing rolloff
# (this may take a few minutes to run, and the results may vary)
m2 = matchPars(target = target,
               samplingRate = 16000,
               pars = 'rolloff',
               maxIter = 100,
               verbose = playback)
# rolloff should be moving from default (-12) to target (-5):
sapply(m2$history, function(x) x$pars$rolloff)
cand2 = do.call(soundgen, c(m2$pars, list(play = playback, temperature = 0)))
}
}
