% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{pathfinder}
\alias{pathfinder}
\title{Pathfinder}
\usage{
pathfinder(pitchCands, pitchCert, pitchSource, manual = NULL,
  certWeight = 0.5, pathfinding = c("none", "fast", "slow")[2],
  annealPars = list(maxit = 5000, temp = 1000), interpolWin_bin = 3,
  interpolTol = 0.05, interpolCert = 0.3, manualCert = 1,
  snakeStep = 0.05, snakePlot = FALSE)
}
\arguments{
\item{pitchCands}{a matrix of multiple pitch candidates per fft frame. Each
column is one fft frame, each row is one candidate (the last row is always
"manual")}

\item{pitchCert}{a matrix of the same dimensionality as pitchCands specifying
our certainty in pitch candidates}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}

\item{pathfinding}{method of finding the optimal path through pitch
candidates: 'none' = best candidate per frame, 'fast' = simple heuristic,
'slow' = annealing. See \code{soundgen:::pathfinder}}

\item{annealPars}{a list of control parameters for postprocessing of
pitch contour with SANN algorithm of \code{\link[stats]{optim}}. This is
only relevant if \code{pathfinding = 'slow'}}

\item{interpolWin_bin}{when interpolating pitch candidates, the median is
calculated over \code{plus-minus interpolWin_bin}}

\item{interpolTol}{when interpolating pitch candidates, the criterion
for needing to interpolate is the absence of pitch candidates with values
within \code{1 plus-minus interpolTol} of the median of pitch center of
gravity over the interpolation window. For ex., if \code{interpolTol}
is .05, we look for values from 0.95 to 1.05 time the median value over
interpolation window.}

\item{interpolCert}{when interpolating pitch candidates, all generated pitch
candidates are assigned a certainty equal to \code{interpolCert}}

\item{manualCert}{the certainty in manually added pitch candidates}

\item{snakeStep}{optimized path through pitch candidates is further
processed to minimize the elastic force acting on pitch contour. To
disable, set \code{snakeStep = 0}}

\item{snakePlot}{if TRUE, plots the snake}
}
\value{
Returns a numeric vector of pitch values representing the best found
  path through pitch candidates.
}
\description{
Internal soundgen function.
}
\details{
Internal helper function for postprocessing pitch contour. Starts with a
reasonable guess and computes the more-or-less optimal pitch contour (not
quite the very optimal - too computationally expensive).
}
\keyword{internal}
