% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertModulSpec.R
\name{specToMS}
\alias{specToMS}
\title{Spectrogram to modulation spectrum}
\usage{
specToMS(spec, windowLength = NULL, step = NULL)
}
\arguments{
\item{spec}{target spectrogram (numeric matrix, frequency in rows, time in
columns)}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}
}
\value{
Returns a MS - matrix of complex values of the same dimension as
  spec, with AM in rows and FM in columns.
}
\description{
Takes a spectrogram (either complex or magnitude) and returns a MS with
proper row and column labels.
}
\examples{
s = soundgen(sylLen = 500, amFreq = 25, amDep = 50,
             pitch = 250, samplingRate = 16000)
spec = spectrogram(s, samplingRate = 16000, windowLength = 25, step = 5)
ms = specToMS(spec)
image(x = as.numeric(colnames(ms)), y = as.numeric(rownames(ms)),
      z = t(log(abs(ms))), xlab = 'Amplitude modulation, Hz',
      ylab = 'Frequency modulation, cycles/kHz')
}
