% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{generateEpoch}
\alias{generateEpoch}
\title{Generate an epoch}
\usage{
generateEpoch(pitch_per_gc, epochs, rolloff_per_epoch, samplingRate)
}
\arguments{
\item{pitch_per_gc}{pitch per glottal cycle, Hz}

\item{epochs}{a dataframe specifying the beginning and end of each epoch}

\item{rolloff_per_epoch}{a list of matrices with one matrix for each epoch; each
matrix should contain one column for each glottal cycle and one row for
each harmonic (linear multiplier, ie NOT in dB). Rownames specify the ratio
to F0 (eg 1.5 means it's a subharmonic added between f0 and its first
harmonic)}

\item{samplingRate}{the sampling rate of generated sound, Hz}
}
\value{
Returns a waveform as a non-normalized numeric vector centered at zero.
}
\description{
Internal soundgen function.
Takes descriptives of a number of glottal cycles (f0, closed phase, rolloff)
and creates a continuous waveform. The principle is to work with one epoch
with stable regime of subharmonics at a time and create a sine wave for each
harmonic, with amplitudes adjusted by rolloff.
}
\examples{
pitch_per_gc = seq(100, 150, length.out = 90)
epochs = data.frame (start = c(1, 51),
                     end = c(50, 90))
m1 = matrix(rep(10 ^ (-6 * log2(1:200) / 20), 50), ncol = 50, byrow = FALSE)
m2 = matrix(rep(10 ^ (-12 * log2(1:200) / 20), 40), ncol = 40, byrow = FALSE)
rownames(m1) = 1:nrow(m1)
rownames(m2) = 1:nrow(m2)
rolloff_source = list(m1, m2)
s = soundgen:::generateEpoch(pitch_per_gc, epochs,
                             rolloff_source, samplingRate = 16000)
# plot(s, type = 'l')
# playme(s)
}
\keyword{internal}
