% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_formants.R
\name{convertStringToFormants}
\alias{convertStringToFormants}
\title{Prepare a list of formants}
\usage{
convertStringToFormants(phonemeString, speaker = "M1")
}
\arguments{
\item{phonemeString}{a string of characters from the dictionary of phoneme
presets, e.g., uaaaaii (short u - longer a - medium-long i)}

\item{speaker}{name of the preset dictionary to use}
}
\value{
Returns a list of formant values, which can be fed directly into
  \code{\link{getSpectralEnvelope}}
}
\description{
Internal soundgen function.
}
\details{
Takes a string of phonemes entered WITHOUT ANY BREAKS. Recognized phonemes in
the human preset dictionary: vowels "a" "o" "i" "e" "u" "0" (schwa);
consonants "s" "x" "j".
}
\examples{
formants = soundgen:::convertStringToFormants(phonemeString = 'a')
formants = soundgen:::convertStringToFormants(
  phonemeString = 'au', speaker = 'M1')
formants = soundgen:::convertStringToFormants(
  phonemeString = 'aeui', speaker = 'F1')
formants = soundgen:::convertStringToFormants(
  phonemeString = 'aaeuiiiii', speaker = 'Chimpanzee')
}
\keyword{internal}
