% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchDescriptives.R
\name{pitchDescriptives}
\alias{pitchDescriptives}
\title{Pitch descriptives}
\usage{
pitchDescriptives(
  x,
  step = NULL,
  timeUnit,
  smoothBW = c(NA, 10, 1),
  inflThres = 0.2,
  extraSummaryFun = c(),
  ref = 16.35,
  plot = FALSE
)
}
\arguments{
\item{x}{input: numeric vector, a list of time stamps and values in rows, a
dataframe with one row per file and time/pitch values stored as characters
(as exported by \code{\link{pitch_app}}), or path to csv file containing
the output of \code{\link{pitch_app}} or \code{\link{analyze}}}

\item{step}{distance between values in s (only needed if input is a vector)}

\item{timeUnit}{specify whether the time stamps (if any) are in ms or s}

\item{smoothBW}{a vector of bandwidths (Hz) for consecutive smoothing of
input using \code{\link{pitchSmoothPraat}}; NA = no smoothing}

\item{inflThres}{minimum difference (in semitones) between consecutive
extrema to consider them inflections; to apply a different threshold at
each smoothing level, provide \code{inflThres} as a vector of the same
length as \code{smoothBW}; NA = no threshold}

\item{extraSummaryFun}{additional summary function(s) that take a numeric
vector with some NAs and return a single number, eg c('myFun1', 'myFun2')}

\item{ref}{reference value for transforming Hz to semitones, defaults to
C0 (16.35 Hz)}

\item{plot}{if TRUE, plots the inflections for manual verification}
}
\value{
Returns a dataframe with columns containing summaries of one or
  multiple inputs (one input per row). The descriptives are as follows:
  \describe{\item{duration}{total duration, s} \item{durDefined}{duration
  after omitting leading and trailing NAs} \item{propDefined}{proportion of
  input with non-NA value, eg proportion of voiced frames if the input is
  pitch} \item{start, start_oct, end, end_oct}{the first and last values on
  the original scale and in octaves above C0 (16.3516 Hz)} \item{mean,
  median, max, min}{average and extreme values on the original scale}
  \item{mean_oct, median_oct, min_oct, max_oct}{same in octaves above C0}
  \item{time_max, time_min}{the location of minimum and maximum relative to
  durDefined, 0 to 1} \item{range, range_sem, sd, sd_sem}{range and standard
  deviation on the original scale and in semitones} \item{CV}{coefficient of
  variation = sd/mean (provided for historical reasons)} \item{meanSlope,
  meanSlope_sem}{mean slope in Hz/s or semitones/s (NB: does not depend on
  duration or missing values)} \item{meanAbsSlope, meanAbsSlope_sem}{mean
  absolute slope (modulus, ie rising and falling sections no longer cancel
  out)} \item{maxAbsSlope, maxAbsSlope_sem}{the steepest slope}}
}
\description{
Provides common descriptives of time series such as pitch contours, including
measures of average / range / variability / slope / inflections etc. Several
degrees of smoothing can be applied consecutively. The summaries are produced
on the original and log-transformed scales, so this is meant to be used on
frequency-related variables in Hz.
}
\examples{
x = c(NA, NA, 405, 441, 459, 459, 460, 462, 462, 458, 458, 445, 458, 451,
444, 444, 430, 416, 409, 403, 403, 389, 375, NA, NA, NA, NA, NA, NA, NA, NA,
NA, 183, 677, 677, 846, 883, 886, 924, 938, 883, 946, 846, 911, 826, 826,
788, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 307,
307, 368, 377, 383, 383, 383, 380, 377, 377, 377, 374, 374, 375, 375, 375,
375, 368, 371, 374, 375, 361, 375, 389, 375, 375, 375, 375, 375, 314, 169,
NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 238, 285, 361, 374, 375, 375,
375, 375, 375, 389, 403, 389, 389, 375, 375, 389, 375, 348, 361, 375, 348,
348, 361, 348, 342, 361, 361, 361, 365, 365, 361, 966, 966, 966, 959, 959,
946, 1021, 1021, 1026, 1086, 1131, 1131, 1146, 1130, 1172, 1240, 1172, 1117,
1103, 1026, 1026, 966, 919, 946, 882, 832, NA, NA, NA, NA, NA, NA, NA, NA,
NA, NA)
plot(x, type = 'b')
ci95 = function(x) diff(quantile(na.omit(x), probs = c(.025, .975)))
pd = pitchDescriptives(
  x, step = .025, timeUnit = 's',
  smoothBW = c(NA, 10, 1),   # original + smoothed at 10 Hz and 1 Hz
  inflThres = c(NA, .2, .2), # different for each level of smoothing
  extraSummaryFun = 'ci95',  # user-defined, here 95\% coverage interval
  plot = TRUE
)
pd

\dontrun{
# a single file
data(sheep, package = 'seewave')
a = analyze(sheep)
pd1 = pitchDescriptives(a$detailed[, c('time', 'pitch')],
                        timeUnit = 'ms', inflThres = NA, plot = TRUE)
pd2 = pitchDescriptives(a$detailed[, c('time', 'pitch')],
                        timeUnit = 'ms', inflThres = c(0.1, 0.1, .5), plot = TRUE)

# multiple files returned by analyze()
an = analyze('~/Downloads/temp')
pd = pitchDescriptives(an$detailed, timeUnit = 'ms')
pd

# multiple files returned by pitch_app()
pd = pitchDescriptives(
  '~/Downloads/pitch_manual_1708.csv',
  timeUnit = 'ms', smoothBW = c(NA, 2), inflThres = .25)

# a single file, exported from Praat
par(mfrow = c(3, 1))
pd = pitchDescriptives(
  '~/Downloads/F-Hin-Om_jana.wav_F0contour.txt',
  timeUnit = 's', smoothBW = c(NA, 25, 2), inflThres = .25, plot = TRUE)
par(mfrow = c(1, 1))
}
}
