% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_utilities.R
\name{getFeatureFlux}
\alias{getFeatureFlux}
\title{Get flux from features}
\usage{
getFeatureFlux(an, thres = 0.1, smoothing_ww = 1, plot = FALSE)
}
\arguments{
\item{an}{dataframe of results from analyze()}

\item{thres}{threshold used for epoch detection (0 - 1)}

\item{smoothing_ww}{if > 1, \code{\link{medianSmoother}} is called on input dataframe}

\item{plot}{if TRUE, plots the normalized feature matrix and epochs}
}
\value{
Returns a data frame with flux per frame and epoch numbers.
}
\description{
Internal soundgen function
}
\details{
Calculates the change in acoustic features returned by analyze() from one
STFT frame to the next. Since the features are on different scales, they are
normalized depending on their units (but not scaled). Flux is calculated as
mean absolute change across all normalized features. Whenever flux exceeds
\code{thres}, a new epoch begins.
}
\examples{
an = analyze(soundgen(), 16000)
fl = soundgen:::getFeatureFlux(an$detailed, plot = TRUE)
\dontrun{
# or simply:
an = analyze(soundgen(sylLen = 500), 16000, plot = TRUE, ylim = c(0, 8),
             extraContour = 'flux', flux = list(smoothWin = 100, thres = .15))
}
}
\keyword{internal}
